/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantHelper;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class SugarcaneGen
extends PlantGenBase {
    private final Predicate<BlockPos2D> extraTallChance;

    public SugarcaneGen(DependencyInjector di) {
        super(di, "infinibiome:sugarcane");
        this.config = this.initConfig().setPlantBlockFunc(this::getPlantBlocks).setSampleBlock(Blocks.field_196608_cF).setAboveWater().setRate(new Interval(0.1, 0.1)).setRadius(new Interval(7.0, 7.0)).setDensity(new Interval(0.4, 0.4)).neverInMushroomIsland().anyTemperatureIncludingFreezing().setHumdity(GenHelper.WETISH).setNoSpawnRegion().setExtraConditions(ConditionHelper.onlyInLandMass(di, LandmassInfo::isLand), new Condition[0]).setBoneMealPlantFunc(this::getPlantBlocksOnBoneMeal);
        this.extraTallChance = Helper.initUniformNoise(this.seed.newSeed("extraTallChance"), 2048.0).mapInterval(new Interval(0.0, 0.5)).randomBool(BlockPos2D.INFO, this.seed);
    }

    private List<BlockState> getPlantBlocks(BlockPos plantPos, IWorldReader world, Random random) {
        if (!this.hasWater(plantPos.func_177977_b(), world)) {
            return Collections.emptyList();
        }
        if (this.extraTallChance.test(MCHelper.to2D(plantPos))) {
            return Collections.nCopies(4, Blocks.field_196608_cF.func_176223_P());
        }
        return Collections.nCopies(3, Blocks.field_196608_cF.func_176223_P());
    }

    private boolean hasWater(BlockPos pos, IWorldReader world) {
        for (Direction d : MCHelper.NSWE) {
            if (PlantHelper.iceAtPos(pos.func_177972_a(d), world, this.posData) || !MCHelper.isMostlyWater(world.func_180495_p(pos.func_177972_a(d)))) continue;
            return true;
        }
        return false;
    }

    private List<BlockState> getPlantBlocksOnBoneMeal(BlockPos plantPos, IWorldReader world, Random random) {
        return Lists.newArrayList((Object[])new BlockState[]{Blocks.field_196608_cF.func_176223_P()});
    }
}

