/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantHelper;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class SunflowerGen
extends PlantGenBase {
    public SunflowerGen(DependencyInjector di) {
        super(di, "infinibiome:sunflower");
        this.config = this.initConfig().setPlantBlockFunc(this::getPlantBlocks).setSampleBlock(Blocks.field_196800_gd).setAboveWater().setScatteredRate(new Interval(0.0, 128.0)).neverInMushroomIsland().anyNonFreezingTemperature().setHumdity(GenHelper.DRYISH).setSpawnRegion(0.3f).setExtraConditions(ConditionHelper.onlyInTreeDensity(di, GenHelper.NON_FORESTED_TREE_INTERVAL), new Condition[0]);
    }

    private List<BlockState> getPlantBlocks(BlockPos pos, IWorldReader world, Random random) {
        if (!this.validSpace(pos, world)) {
            return Collections.emptyList();
        }
        return PlantHelper.initDouble(Blocks.field_196800_gd);
    }

    private boolean validSpace(BlockPos plantPos, IWorldReader world) {
        BlockPos startingPos = plantPos.func_177984_a();
        for (int i = 1; i <= 6; ++i) {
            BlockPos currPos = startingPos.func_177967_a(Direction.EAST, i).func_177967_a(Direction.UP, i);
            if (world.func_180495_p(currPos).func_196958_f()) continue;
            return false;
        }
        return true;
    }
}

