/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import org.jetbrains.annotations.Nullable;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class VineGen
extends PlantGenBase {
    private final Type type;

    public VineGen(Type type, DependencyInjector di) {
        super(di, "infinibiome:vine" + type.name());
        this.type = type;
        this.config = this.initConfig().setPlantBlockFunc(this::getPlant).setSampleBlock(Blocks.field_150395_bd).setAboveWater().setScatteredRate(new Interval(32.0, 255.0)).alsoInMushroomIsland().anyNonFreezingTemperature().setHumdity(type.humidity).setSpawnRegion(type.regionRate).setNoExtraConditions().setNoGroundCheck();
    }

    public String toString() {
        return "VineGen{type=" + (Object)((Object)this.type) + '}';
    }

    private List<@Nullable BlockState> getPlant(BlockPos plantPos3D, IWorldReader world, Random random) {
        BlockPos2D plantPos = MCHelper.to2D(plantPos3D);
        Integer maxHeight = this.getHighestHeight(plantPos, world, random);
        if (maxHeight == null) {
            return Collections.emptyList();
        }
        BlockState vineBlockState = this.getValidVineState(plantPos.to3D(maxHeight), world);
        assert (vineBlockState != null);
        ArrayList<BlockState> result = new ArrayList<BlockState>();
        boolean obstructed = false;
        for (int y = maxHeight.intValue(); y >= plantPos3D.func_177956_o(); --y) {
            if (!MCHelper.isMostlyAir(world.func_180495_p(plantPos.to3D(y)))) {
                obstructed = true;
            }
            if (obstructed) {
                result.add(0, null);
                continue;
            }
            result.add(0, vineBlockState);
        }
        return result;
    }

    @Nullable
    private Integer getHighestHeight(BlockPos2D plantPos, IWorldReader world, Random random) {
        int startingHeight = MCHelper.getHighestTerrainHeight(plantPos, world);
        int maxHeight = MCHelper.getHighestNonAirY(plantPos, world);
        BlockPos.Mutable checkPos = new BlockPos.Mutable(plantPos.getBlockX(), startingHeight, plantPos.getBlockZ());
        IntArrayList validHeights = new IntArrayList();
        while (checkPos.func_177956_o() <= maxHeight) {
            if (this.getValidVineState((BlockPos)checkPos, world) != null) {
                validHeights.add(checkPos.func_177956_o());
            }
            checkPos.func_189536_c(Direction.UP);
        }
        if (validHeights.isEmpty()) {
            return null;
        }
        int randomIndex = random.nextInt(validHeights.size());
        return validHeights.getInt(randomIndex);
    }

    @Nullable
    private BlockState getValidVineState(BlockPos pos, IWorldReader world) {
        BlockState block = Blocks.field_150395_bd.func_176223_P();
        boolean set = false;
        for (Direction d : MCHelper.NSWE) {
            if (!this.canSustainVine(pos, world, d)) continue;
            block = this.setState(block, d);
            set = true;
        }
        if (!set) {
            return null;
        }
        return block;
    }

    private boolean canSustainVine(BlockPos pos, IWorldReader world, Direction direction) {
        return this.setState(Blocks.field_150395_bd.func_176223_P(), direction).func_196955_c(world, pos);
    }

    private BlockState setState(BlockState block, Direction direction) {
        BooleanProperty property = (BooleanProperty)SixWayBlock.field_196491_B.get(direction);
        return (BlockState)block.func_206870_a((IProperty)property, (Comparable)Boolean.valueOf(true));
    }

    public static enum Type {
        WET((double)0.6f, GenHelper.WETISH),
        DRY((double)0.3f, GenHelper.DRYISH);

        private final double regionRate;
        private final Interval humidity;

        private Type(double regionRate, Interval humidity) {
            this.regionRate = regionRate;
            this.humidity = humidity;
        }
    }
}

