/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.SmallObjectGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class IceSpikeGen
extends SmallObjectGenBase
implements Locatable.HasPointsProvider {
    public IceSpikeGen(DependencyInjector di) {
        super(di, "infinibiome:iceSpikes");
        this.config = this.initConfig().setWithFeature(new FixedIceSpikeFeature()).setCount(Helper.initUniformNoise(this.seed.newSeed("count"), 2048.0).mapInterval(new Interval(0.0, 4.0))).setAttemptsPerCount(4).aboveHighestTerrainBlock().onlyInRegion(0.1f).addExtraConditions(ConditionHelper.onlyInTemperature(di, PosDataHelper.FREEZE_INTERVAL), new Condition[0]);
    }

    private static class FixedIceSpikeFeature
    extends Feature<NoFeatureConfig> {
        FixedIceSpikeFeature() {
            super(NoFeatureConfig::func_214639_a);
        }

        public boolean place(IWorld p_212245_1_, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random p_212245_3_, BlockPos p_212245_4_, NoFeatureConfig p_212245_5_) {
            int l;
            int k;
            while (p_212245_1_.func_175623_d(p_212245_4_) && p_212245_4_.func_177956_o() > 2) {
                p_212245_4_ = p_212245_4_.func_177977_b();
            }
            p_212245_4_ = p_212245_4_.func_177981_b(p_212245_3_.nextInt(4));
            int i = p_212245_3_.nextInt(4) + 7;
            int j = i / 4 + p_212245_3_.nextInt(2);
            if (j > 1 && p_212245_3_.nextInt(60) == 0) {
                p_212245_4_ = p_212245_4_.func_177981_b(10 + p_212245_3_.nextInt(30));
            }
            for (k = 0; k < i; ++k) {
                double f = (1.0 - (double)k / (double)i) * (double)j;
                l = MathHelper.func_76143_f((double)f);
                for (int i1 = -l; i1 <= l; ++i1) {
                    double f1 = (double)MathHelper.func_76130_a((int)i1) - 0.25;
                    for (int j1 = -l; j1 <= l; ++j1) {
                        double f2 = (double)MathHelper.func_76130_a((int)j1) - 0.25;
                        if ((i1 != 0 || j1 != 0) && !(f1 * f1 + f2 * f2 <= f * f) || (i1 == -l || i1 == l || j1 == -l || j1 == l) && !(p_212245_3_.nextFloat() <= 0.75f)) continue;
                        BlockState blockstate = p_212245_1_.func_180495_p(p_212245_4_.func_177982_a(i1, k, j1));
                        if (this.isValid(blockstate)) {
                            this.func_202278_a((IWorldWriter)p_212245_1_, p_212245_4_.func_177982_a(i1, k, j1), Blocks.field_150403_cj.func_176223_P());
                        }
                        if (k == 0 || l <= 1 || !this.isValid(blockstate = p_212245_1_.func_180495_p(p_212245_4_.func_177982_a(i1, -k, j1)))) continue;
                        this.func_202278_a((IWorldWriter)p_212245_1_, p_212245_4_.func_177982_a(i1, -k, j1), Blocks.field_150403_cj.func_176223_P());
                    }
                }
            }
            k = j - 1;
            if (k < 0) {
                k = 0;
            } else if (k > 1) {
                k = 1;
            }
            for (int l1 = -k; l1 <= k; ++l1) {
                for (l = -k; l <= k; ++l) {
                    BlockState blockstate1;
                    BlockPos blockpos = p_212245_4_.func_177982_a(l1, -1, l);
                    int j2 = 50;
                    if (Math.abs(l1) == 1 && Math.abs(l) == 1) {
                        j2 = p_212245_3_.nextInt(5);
                    }
                    while (blockpos.func_177956_o() > 50 && this.isValid(blockstate1 = p_212245_1_.func_180495_p(blockpos))) {
                        this.func_202278_a((IWorldWriter)p_212245_1_, blockpos, Blocks.field_150403_cj.func_176223_P());
                        blockpos = blockpos.func_177977_b();
                        if (--j2 > 0) continue;
                        blockpos = blockpos.func_177979_c(p_212245_3_.nextInt(5) + 1);
                        j2 = p_212245_3_.nextInt(5);
                    }
                }
            }
            return true;
        }

        private boolean isValid(BlockState block) {
            if (MCHelper.isMostlyAir(block)) {
                return true;
            }
            if (MCHelper.isMostlyWater(block)) {
                return true;
            }
            if (Tags.Blocks.DIRT.func_199685_a_((Object)block.func_177230_c())) {
                return true;
            }
            if (Tags.Blocks.SAND.func_199685_a_((Object)block.func_177230_c())) {
                return true;
            }
            if (Tags.Blocks.GRAVEL.func_199685_a_((Object)block.func_177230_c())) {
                return true;
            }
            if (BlockTags.field_205213_E.func_199685_a_((Object)block.func_177230_c())) {
                return true;
            }
            return block.func_177230_c().equals(Blocks.field_196604_cC);
        }
    }
}

