/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.SmallObjectGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class IceburgGen
extends SmallObjectGenBase
implements Locatable.HasPointsProvider {
    private final Type type;

    public IceburgGen(Type type, DependencyInjector di) {
        super(di, "infinibiome:iceburg" + type.name());
        this.type = type;
        BlockStateFeatureConfig featureConfig = new BlockStateFeatureConfig(type.block);
        this.config = this.initConfig().setWithFeature(Feature.field_205172_ag, featureConfig).setCount(1.0).setAttemptsPerCount(4).customHeightFunc((pos, world, random) -> MCHelper.getHighestTerrainHeight(pos, (IWorldReader)world)).setChancePerChunk(type.rate).addExtraConditions(ConditionHelper.onlyInTemperature(di, GenHelper.LOWER_FREEZE_INTERVAL), ConditionHelper.onlyInHeight(di, new Interval(0.0, 43.0)), ConditionHelper.onlyInLandMass(di, LandmassInfo::isOcean));
    }

    public String toString() {
        return "Iceburg{type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        ICE(Blocks.field_150432_aD.func_176223_P(), 0.0625),
        BLUE_ICE(Blocks.field_205164_gk.func_176223_P(), 0.005);

        private final BlockState block;
        private final double rate;

        private Type(BlockState block, double rate) {
            this.block = block;
            this.rate = rate;
        }
    }
}

