/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.raid.Raid;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.SpawnPointBlacklist;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructConfigBase;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructHelper;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.VillageGen;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.EntityHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class IllagerOutpostGen
extends StructGenBase
implements SpawnPointBlacklist {
    private static final List<SpawnEntity> entitiesOutsideStruct = new ArrayList<SpawnEntity>();
    private static final List<SpawnEntity> entitiesInsideStruct = new ArrayList<SpawnEntity>();
    private static final double INSIDE_STRUCT_PROBABILITY = 0.05;
    private static final double OUTSIDE_STRUCT_PROBABILITY = 5.0E-4;

    public IllagerOutpostGen(DependencyInjector di) {
        super(di, "infinibiome:outpost");
        this.config = this.initConfig().withStruct((Structure<NoFeatureConfig>)Feature.field_214536_b).withChance(Config.class, 2).addExtraConditions(ConditionHelper.onlyInLandMass(di, LandmassInfo::isLand), StructHelper.alwaysAboveWater(di, 20), ConditionHelper.onlyIfNotNear(di, 10, (v, p) -> v.config.conditions.canBeHere((InterChunkPos)p), VillageGen.class));
    }

    @Override
    public void postGenerate(InterChunkPos pos, IWorld world) {
        StructHelper.placeDirtUnderStruct(pos, world, this.posData);
        this.spawnIllagers(pos, world);
        this.spawnLeaderPillager(pos, world);
    }

    private void spawnIllagers(InterChunkPos interChunkPos, IWorld world) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        interChunkPos.forEachCenterPos(pos -> {
            List<Integer> validHeights = this.getValidHeights((BlockPos2D)pos, world);
            boolean insideStruct = validHeights.size() > 1;
            double probability = this.getProbability(insideStruct);
            for (int height : validHeights) {
                if (!MathHelper.randomBool(probability, random)) {
                    return;
                }
                this.spawnIllager(pos.to3D(height), world, random, insideStruct);
            }
        });
    }

    private double getProbability(boolean inSideStruct) {
        if (inSideStruct) {
            return 0.05;
        }
        return 5.0E-4;
    }

    private List<Integer> getValidHeights(BlockPos2D pos, IWorld world) {
        int minHeight;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int y = minHeight = (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, pos); y < 255; ++y) {
            BlockState floor = world.func_180495_p(pos.to3D(y - 1));
            BlockState air1 = world.func_180495_p(pos.to3D(y));
            BlockState air2 = world.func_180495_p(pos.to3D(y + 1));
            if (BlockTags.field_206952_E.func_199685_a_((Object)floor.func_177230_c()) || !MCHelper.isSolid(floor) || !MCHelper.isMostlyAir(air1) || !MCHelper.isMostlyAir(air2)) continue;
            result.add(y);
        }
        return result;
    }

    private void spawnIllager(BlockPos pos, IWorld world, Random random, boolean insideStruct) {
        List<SpawnEntity> list = insideStruct ? entitiesInsideStruct : entitiesOutsideStruct;
        Entity entity = list.get(random.nextInt(list.size())).get(world);
        if (insideStruct) {
            IllagerOutpostGen.removeWanderingAI((MobEntity)entity);
        }
        MCHelper.spawnEntity(entity, pos, world);
    }

    private void spawnLeaderPillager(InterChunkPos interChunkPos, IWorld world) {
        interChunkPos.forEachCenterPos(pos -> {
            int lowestY = (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, (BlockPos2D)pos);
            int highestY = MCHelper.getHighestNonAirY(pos, (IWorldReader)world);
            for (int y = lowestY; y < highestY; ++y) {
                Block block = world.func_180495_p(pos.to3D(y)).func_177230_c();
                if (!block.equals(Blocks.field_150486_ae)) continue;
                MCHelper.spawnEntity((Entity)IllagerOutpostGen.getPillagerLeader(world), pos.to3D(y), world);
                return;
            }
        });
    }

    private static PillagerEntity getPillagerLeader(IWorld world) {
        PillagerEntity pillager = IllagerOutpostGen.getPillager(world);
        pillager.func_184201_a(EquipmentSlotType.HEAD, Raid.func_221312_H());
        IllagerOutpostGen.removeWanderingAI((MobEntity)pillager);
        return pillager;
    }

    private static PillagerEntity getPillager(IWorld world) {
        PillagerEntity pillager = new PillagerEntity(EntityType.field_220350_aJ, world.func_201672_e());
        pillager.func_110163_bv();
        pillager.func_184201_a(EquipmentSlotType.MAINHAND, Items.field_222114_py.func_190903_i());
        return pillager;
    }

    private static Entity getVindicator(IWorld world) {
        VindicatorEntity vindicator = new VindicatorEntity(EntityType.field_200758_ax, world.func_201672_e());
        vindicator.func_110163_bv();
        vindicator.func_184201_a(EquipmentSlotType.MAINHAND, Items.field_151036_c.func_190903_i());
        return vindicator;
    }

    private static Entity getEvoker(IWorld world) {
        EvokerEntity evoker = new EvokerEntity(EntityType.field_200806_t, world.func_201672_e());
        evoker.func_110163_bv();
        return evoker;
    }

    private static IllusionerEntity getIllusioner(IWorld world) {
        IllusionerEntity illusioner = new IllusionerEntity(EntityType.field_200764_D, world.func_201672_e());
        illusioner.func_110163_bv();
        return illusioner;
    }

    private static void removeWanderingAI(MobEntity entity) {
        EntityHelper.removeGoals(entity.field_70714_bg, g -> g instanceof RandomWalkingGoal);
    }

    @Override
    public boolean canSpawnHere(BlockPos2D pos) {
        Iterator<BlockPos2D> iterator = this.getAllLocations().getBoundedPoints(pos, 32.0).iterator();
        if (iterator.hasNext()) {
            BlockPos2D ignored = iterator.next();
            return false;
        }
        return true;
    }

    static {
        entitiesOutsideStruct.addAll(Collections.nCopies(10, IllagerOutpostGen::getPillager));
        entitiesOutsideStruct.addAll(Collections.nCopies(5, IllagerOutpostGen::getVindicator));
        entitiesOutsideStruct.addAll(Collections.nCopies(2, IllagerOutpostGen::getIllusioner));
        entitiesInsideStruct.addAll(Collections.nCopies(10, IllagerOutpostGen::getVindicator));
        entitiesInsideStruct.addAll(Collections.nCopies(5, IllagerOutpostGen::getPillager));
        entitiesInsideStruct.addAll(Collections.nCopies(2, IllagerOutpostGen::getEvoker));
    }

    public static final class Config
    extends StructConfigBase {
        public Config(DependencyInjector di) {
            super(di);
        }

        @Override
        String name() {
            return "illager_outpost_rate";
        }

        @Override
        double defaultRate() {
            return 0.001;
        }
    }

    private static interface SpawnEntity {
        public Entity get(IWorld var1);
    }
}

