/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructConfigBase;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class JunglePyramidGen
extends StructGenBase {
    private static final Map<Block, BlockState> INFESTED_BLOCKS = new HashMap<Block, BlockState>();
    private static final List<Block> PUZZLE_COMPONENTS = Lists.newArrayList((Object[])new Block[]{Blocks.field_196702_dl, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_196633_cV});
    private static final double INFESTED_RATE = 0.05;

    public JunglePyramidGen(DependencyInjector di) {
        super(di, "infinibiome:junglePyramid");
        this.config = this.initConfig().withStruct((Structure<NoFeatureConfig>)Feature.field_202331_i).withChance(Config.class, 8).addExtraConditions(ConditionHelper.onlyInTemperature(di, PosDataHelper.HOT_INTERVAL), ConditionHelper.onlyInHumidity(di, PosDataHelper.WET_INTERVAL), ConditionHelper.onlyInHeight(di, new Interval(64.0, Double.POSITIVE_INFINITY)), ConditionHelper.onlyInLandMass(di, LandmassInfo::isLand), ConditionHelper.onlyInTreeDensity(di, new Interval(0.5, Double.POSITIVE_INFINITY)));
    }

    @Override
    public void postGenerate(InterChunkPos interChunkPos, IWorld world) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        interChunkPos.forEachCenterPos(pos2D -> {
            int minHeight = MCHelper.getHighestTerrainHeight(pos2D, (IWorldReader)world) - 10;
            for (int y = 255; y > minHeight; --y) {
                BlockPos pos = pos2D.to3D(y);
                BlockState replacementBlock = this.getReplacementBlock(pos, (IWorldReader)world, random);
                if (replacementBlock == null) continue;
                world.func_180501_a(pos, replacementBlock, 20);
            }
        });
    }

    @Nullable
    private BlockState getReplacementBlock(BlockPos pos, IWorldReader world, Random random) {
        if (this.belowRedstone(pos, world)) {
            return null;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.isNearPuzzleComponents(pos, world)) {
            if (block.equals(Blocks.field_150341_Y)) {
                return Blocks.field_196687_dd.func_176223_P();
            }
            return INFESTED_BLOCKS.get(block);
        }
        if (!MathHelper.randomBool(0.05, random)) {
            return null;
        }
        return INFESTED_BLOCKS.get(block);
    }

    private boolean isNearPuzzleComponents(BlockPos pos, IWorldReader world) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currPos = pos.func_177982_a(x, y, z);
                    Block currBlock = world.func_180495_p(currPos).func_177230_c();
                    if (!PUZZLE_COMPONENTS.contains(currBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean belowRedstone(BlockPos pos, IWorldReader world) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c().equals(Blocks.field_150488_af);
    }

    static {
        INFESTED_BLOCKS.put(Blocks.field_150347_e, Blocks.field_196687_dd.func_176223_P());
        INFESTED_BLOCKS.put(Blocks.field_196702_dl, Blocks.field_196694_dh.func_176223_P());
    }

    public static final class Config
    extends StructConfigBase {
        public Config(DependencyInjector di) {
            super(di);
        }

        @Override
        String name() {
            return "jungle_pyramid_rate";
        }

        @Override
        double defaultRate() {
            return 0.1;
        }
    }
}

