/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.generators.nonworldgen.MobSpawnListModifier;
import weightedgpa.infinibiome.api.generators.nonworldgen.MobSpawnListModifierTiming;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructConfigBase;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class OceanMonumentGen
extends StructGenBase
implements MobSpawnListModifier {
    public OceanMonumentGen(DependencyInjector di) {
        super(di, "infinibiome:oceanMonument");
        this.config = this.initConfig().withStruct((Structure<NoFeatureConfig>)Feature.field_202336_n).withChance(Config.class, 16).addExtraConditions(ConditionHelper.onlyInLandMass(di, LandmassInfo::isOcean), ConditionHelper.onlyInHeight(di, 32, new Interval(0.0, 38.0)));
    }

    @Override
    public Timing getMobSpawnModifierTiming() {
        return MobSpawnListModifierTiming.STRUCT;
    }

    @Override
    public void modifyList(BlockPos pos, EntityClassification creatureType, List<Biome.SpawnListEntry> spawnListEntries, IWorld world) {
        if (!Feature.field_202336_n.func_202366_b(world, pos)) {
            return;
        }
        if (creatureType == EntityClassification.WATER_CREATURE) {
            spawnListEntries.clear();
            return;
        }
        if (creatureType != EntityClassification.MONSTER) {
            return;
        }
        spawnListEntries.clear();
        spawnListEntries.addAll(Feature.field_202336_n.func_202279_e());
    }

    public static final class Config
    extends StructConfigBase {
        public Config(DependencyInjector di) {
            super(di);
        }

        @Override
        String name() {
            return "monument_rate";
        }

        @Override
        double defaultRate() {
            return 0.01;
        }
    }
}

