/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructConfigBase;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class OceanRuinGen
extends StructGenBase {
    public OceanRuinGen(DependencyInjector di) {
        super(di, "infinibiome:oceanRuins");
        this.config = this.initConfig().withStructAndFunc(Feature.field_204029_o, this::getConfig).withChance(Config.class, 1).addExtraConditions(ConditionHelper.onlyInHeight(di, new Interval(0.0, 47.0)), ConditionHelper.onlyInLandMass(di, LandmassInfo::isOcean));
    }

    private OceanRuinConfig getConfig(ChunkPos chunkPos) {
        BlockPos2D pos = MCHelper.lowestPos(chunkPos);
        double temperature = PosDataHelper.getTemperature(pos, this.posData);
        if (PosDataHelper.FREEZE_INTERVAL.contains(temperature) || PosDataHelper.COLD_INTERVAL.contains(temperature)) {
            return new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f);
        }
        assert (PosDataHelper.WARM_INTERVAL.contains(temperature) || PosDataHelper.HOT_INTERVAL.contains(temperature));
        return new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f);
    }

    public static final class Config
    extends StructConfigBase {
        public Config(DependencyInjector di) {
            super(di);
        }

        @Override
        String name() {
            return "ocean_ruins_rate";
        }

        @Override
        double defaultRate() {
            return 0.005;
        }
    }
}

