/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructConfigBase;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class ShipWreckGen
extends StructGenBase {
    public ShipWreckGen(DependencyInjector di) {
        super(di, "infinibiome:shipwreck");
        this.config = this.initConfig().withStructAndFunc(Feature.field_204751_l, this::getShipWreckConfig).withChance(Config.class, 1).addExtraConditions(ConditionHelper.onlyInLandMass(di, 0, l -> !l.isLand()), new Condition[0]);
    }

    private ShipwreckConfig getShipWreckConfig(ChunkPos chunkPos) {
        BlockPos2D pos = MCHelper.lowestPos(chunkPos);
        double height = this.posData.get(PosDataKeys.MAPPED_HEIGHT, pos);
        if (height > 58.0) {
            return new ShipwreckConfig(true);
        }
        return new ShipwreckConfig(false);
    }

    public static final class Config
    extends StructConfigBase {
        public Config(DependencyInjector di) {
            super(di);
        }

        @Override
        String name() {
            return "ship_wreck_rate";
        }

        @Override
        double defaultRate() {
            return 0.001;
        }
    }
}

