/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.StructGen;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileConfig;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileSubConfig;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class StrongholdGen
extends GeneratorBase
implements StructGen<NoFeatureConfig> {
    private final ChunkPos[] structureCoords;
    private final Config config;

    public StrongholdGen(DependencyInjector di) {
        super(di, "infinibiome:stronghold");
        this.config = di.getAll(Config.class).get(0);
        this.structureCoords = this.initLocations();
    }

    @Override
    public Structure<NoFeatureConfig> getStruct() {
        return Feature.field_202335_m;
    }

    @Override
    @Nullable
    public NoFeatureConfig getConfigAt(ChunkPos chunkPos) {
        for (ChunkPos location : this.structureCoords) {
            if (!chunkPos.equals((Object)location)) continue;
            return IFeatureConfig.field_202429_e;
        }
        return null;
    }

    @Override
    public BlockPos2D getClosestInstance(BlockPos2D pos) {
        BlockPos blockpos = null;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        double d0 = Double.MAX_VALUE;
        for (ChunkPos chunkpos : this.structureCoords) {
            blockpos$mutable.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
            double d1 = blockpos$mutable.func_177951_i((Vec3i)pos.to3D(0));
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutable);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutable);
            d0 = d1;
        }
        if (blockpos == null) {
            return null;
        }
        return MCHelper.to2D(blockpos);
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        BlockPos pos = interChunkPos.getLowestChunkPos().func_206849_h();
        this.getStruct().func_212245_a(interChunks, this.chunkGenerator, this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ()), pos, null);
    }

    private ChunkPos[] initLocations() {
        int i2 = this.config.distance;
        int j2 = this.config.count;
        int i = this.config.spread;
        ChunkPos[] result = new ChunkPos[j2];
        int j = 0;
        Random random = new Random();
        random.setSeed(this.chunkGenerator.func_202089_c());
        double d1 = random.nextDouble() * Math.PI * 2.0;
        int k = j;
        if (j < result.length) {
            int l = 0;
            int i1 = 0;
            for (int j1 = 0; j1 < result.length; ++j1) {
                int l1;
                double d0 = (double)(4 * i2 + i2 * i1 * 6) + (random.nextDouble() - 0.5) * (double)i2 * 2.5;
                int k1 = (int)Math.round(Math.cos(d1) * d0);
                BlockPos blockpos = Helper.findSuitableSpot(new BlockPos((k1 << 4) + 8, 0, ((l1 = (int)Math.round(Math.sin(d1) * d0)) << 4) + 8), 112, this::isValidPos, MCHelper.MC_POS_INFO);
                if (blockpos != null) {
                    k1 = blockpos.func_177958_n() >> 4;
                    l1 = blockpos.func_177952_p() >> 4;
                }
                if (j1 >= k) {
                    result[j1] = new ChunkPos(k1, l1);
                }
                d1 += Math.PI * 2 / (double)i;
                if (++l != i) continue;
                l = 0;
                i += 2 * i / (++i1 + 1);
                i = Math.min(i, result.length - j1);
                d1 += random.nextDouble() * Math.PI * 2.0;
            }
        }
        return result;
    }

    private boolean isValidPos(BlockPos pos) {
        return Helper.passesSurroundingTest(MCHelper.to2D(pos), 100, p -> this.posData.get(PosDataKeys.MAPPED_HEIGHT, (BlockPos2D)p) > 30.0, BlockPos2D.INFO);
    }

    public static class Config
    implements FileSubConfig {
        private final int count;
        private final int distance;
        private final int spread;

        public Config(DependencyInjector di) {
            FileConfig config = di.get(FileConfig.class).subConfig("STRUCT").subConfig("stronghold");
            this.count = config.getInt("count", 128, 0, 1024, "");
            this.distance = config.getInt("distance", 32, 1, 1024, "");
            this.spread = config.getInt("spread", 3, 1, 1024, "");
        }
    }
}

