/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.StructGen;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.IllagerMansionGen;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructConfigBase;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.minecraftImpl.ChunkDataWriter;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeDetectingWorld;
import weightedgpa.infinibiome.internal.misc.MathHelper;

abstract class StructGenBase
extends GeneratorBase
implements StructGen,
Locatable.HasPointsProvider {
    Config config = null;

    StructGenBase(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
    }

    protected void postGenerate(InterChunkPos interChunkPos, IWorld world) {
    }

    public final Structure getStruct() {
        return this.config.struct;
    }

    @Override
    public final void generate(InterChunkPos interChunkPos, IWorld world) {
        int lowestChunkX = interChunkPos.getLowestChunkPos().field_77276_a;
        int lowestChunkZ = interChunkPos.getLowestChunkPos().field_77275_b;
        boolean hasStruct = false;
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                ChunkPos chunkPos = new ChunkPos(lowestChunkX + x, lowestChunkZ + z);
                boolean hasStructFlag = this.placeStructAtChunk(chunkPos, world);
                hasStruct |= hasStructFlag;
            }
        }
        if (hasStruct) {
            this.postGenerate(interChunkPos, world);
        }
    }

    private boolean placeStructAtChunk(ChunkPos chunkPos, IWorld world) {
        if (this.isMarked(chunkPos)) {
            return true;
        }
        ChangeDetectingWorld worldWrapper = new ChangeDetectingWorld(world);
        SharedSeedRandom sharedSeed = new SharedSeedRandom((long)this.randomGen.getRandomInt(chunkPos.field_77276_a, chunkPos.field_77275_b));
        this.getStruct().func_212245_a((IWorld)worldWrapper, this.chunkGenerator, (Random)sharedSeed, chunkPos.func_206849_h(), null);
        if (worldWrapper.anyChange()) {
            this.mark(chunkPos);
            return true;
        }
        return false;
    }

    private boolean isMarked(ChunkPos chunkPos) {
        CompoundNBT nbt = ChunkDataWriter.readChunk(chunkPos);
        return nbt.func_74764_b(this.getNBTTag());
    }

    private void mark(ChunkPos chunkPos) {
        ChunkDataWriter.write(chunkPos, nbt -> nbt.func_74757_a(this.getNBTTag(), true));
    }

    private String getNBTTag() {
        return "ib:" + this.getStruct().func_143025_a();
    }

    @Nullable
    public final IFeatureConfig getConfigAt(ChunkPos chunkPos) {
        if (!this.shouldSpawnAt(chunkPos)) {
            return null;
        }
        return (IFeatureConfig)this.config.configFunc.apply(chunkPos);
    }

    private boolean shouldSpawnAt(ChunkPos pos) {
        Random random = this.randomGen.getRandom(pos.field_77276_a, pos.field_77275_b);
        double probability = this.config.conditions.getAllProbability(pos, ConditionList.StrictOption.USE_LIKE_NON_STRICT);
        return MathHelper.randomBool(probability, random);
    }

    @Override
    public final Timing getInterChunkTiming() {
        return InterChunkGenTimings.STRUCTS;
    }

    @Override
    public final void checkIsValid() {
        Validate.notNull(this.config);
    }

    @Override
    public final PointsProvider<BlockPos2D> getAllLocations() {
        return this.config.locations.filterOutput(this::shouldSpawnAt).mapPoints(BlockPos2D.INFO);
    }

    final Config.StructureStep initConfig() {
        return new Config().new Config.StructureStep();
    }

    class Config {
        private Structure<?> struct;
        private Function<ChunkPos, ? extends IFeatureConfig> configFunc;
        private PointsProvider<ChunkPos> locations;
        ConditionList conditions;

        Config() {
            this.conditions = new ConditionList(ConditionHelper.onlyWhereInfibiomeGenAllowed(StructGenBase.this.di));
            if (!(StructGenBase.this instanceof IllagerMansionGen)) {
                this.conditions = this.conditions.add(ConditionHelper.onlyIfNotNear(StructGenBase.this.di, 10, (m, p) -> m.config.conditions.canBeHere((InterChunkPos)p), IllagerMansionGen.class).noConflict());
            }
        }

        class ExtraConditionStep {
            ExtraConditionStep() {
            }

            Config addExtraConditions(Condition extraCondition0, Condition ... extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraCondition0);
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }
        }

        class ChanceStep {
            ChanceStep() {
            }

            ExtraConditionStep withChance(Class<? extends StructConfigBase> configClass, int separation) {
                Config.this.locations = ConditionHelper.initSeparatedChunkLocations(StructGenBase.this.seed, separation, ((StructGenBase)StructGenBase.this).di.getAll(configClass).get((int)0).rate);
                Config.this.conditions = Config.this.conditions.add(new Condition.BoolInterpolated(){

                    @Override
                    public boolean passes(BlockPos2D pos) {
                        return Config.this.locations.hasPoint(pos.toChunkPos());
                    }
                });
                return new ExtraConditionStep();
            }
        }

        class StructureStep {
            StructureStep() {
            }

            <T extends IFeatureConfig> ChanceStep withStructAndFunc(Structure<T> struct, Function<ChunkPos, T> configFunc) {
                Config.this.struct = struct;
                Config.this.configFunc = configFunc;
                return new ChanceStep();
            }

            <T extends IFeatureConfig> ChanceStep withStruct(Structure<T> struct, T config) {
                return this.withStructAndFunc(struct, __ -> config);
            }

            ChanceStep withStruct(Structure<NoFeatureConfig> struct) {
                return this.withStruct(struct, IFeatureConfig.field_202429_e);
            }
        }
    }
}

