/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.SingleDep;
import weightedgpa.infinibiome.api.generators.StructGen;

public final class StructGens
implements SingleDep {
    private final List<StructGen<?>> structs = new ArrayList();
    private final Map<Feature<?>, Boolean> hasStructCache = new HashMap();

    public StructGens(DependencyInjector di) {
        di.getAll(StructGen.class).forEach(this.structs::add);
    }

    public boolean containsStruct(Structure<?> struct) {
        return this.hasStructCache.computeIfAbsent((Feature<?>)struct, (Function<Feature<?>, Boolean>)((Function<Feature, Boolean>)__ -> this.structs.stream().anyMatch(s -> s.getStruct().equals(struct))));
    }

    @Nullable
    public <T extends IFeatureConfig> T getConfig(Feature<T> struct, ChunkPos chunkPos2D) {
        for (StructGen<?> p : this.structs) {
            if (!p.getStruct().equals(struct)) continue;
            return (T)p.getConfigAt(chunkPos2D);
        }
        return null;
    }

    public void forEachStructs(Consumer<StructGen<?>> structConsumer) {
        this.structs.forEach(structConsumer);
    }
}

