/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.struct;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.Tags;
import org.apache_.commons.lang3.mutable.MutableInt;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

final class StructHelper {
    private StructHelper() {
    }

    static void placeDirtUnderStruct(InterChunkPos interChunkPos, IWorld world, PosDataProvider data) {
        interChunkPos.forEachCenterPos(p -> {
            int terrainHeight;
            Integer fillDirtHeight = StructHelper.getLowestLocalBuildingBlock(p, world, data);
            if (fillDirtHeight == null) {
                return;
            }
            for (int y = terrainHeight = MCHelper.getHighestTerrainHeight(p, (IWorldReader)world); y < fillDirtHeight; ++y) {
                BlockPos currPos = p.to3D(y);
                world.func_180501_a(currPos, StructHelper.getFillerBlock(p, data), 20);
            }
            if (StructHelper.getFillerBlock(p, data).func_177230_c().equals(Blocks.field_150346_d)) {
                BlockPos grassPos = p.to3D(fillDirtHeight - 1);
                world.func_180501_a(grassPos, Blocks.field_196658_i.func_176223_P(), 20);
            }
        });
    }

    private static BlockState getFillerBlock(BlockPos2D pos, PosDataProvider data) {
        List<BlockState> groundBlocks = data.get(PosDataKeys.GROUND_BLOCKS, pos);
        if (groundBlocks.isEmpty()) {
            return Blocks.field_150347_e.func_176223_P();
        }
        return groundBlocks.get(0);
    }

    @Nullable
    private static Integer getLowestLocalBuildingBlock(BlockPos2D pos, IWorld world, PosDataProvider data) {
        MutableInt overallLowestHeight = new MutableInt(Integer.MAX_VALUE);
        StructHelper.scan(pos, p -> {
            Integer currLowestHeight = StructHelper.getLowestBuildingBlock(p, world);
            if (currLowestHeight == null) {
                return false;
            }
            if (currLowestHeight < overallLowestHeight.getValue()) {
                overallLowestHeight.setValue(currLowestHeight);
            }
            return true;
        });
        if (overallLowestHeight.getValue() == Integer.MAX_VALUE) {
            return null;
        }
        return overallLowestHeight.getValue();
    }

    @Nullable
    private static Integer getLowestBuildingBlock(BlockPos2D pos, IWorld world) {
        int terrainHeight = MCHelper.getHighestTerrainHeight(pos, (IWorldReader)world);
        for (int y = terrainHeight + 1; y < 255; ++y) {
            BlockPos currPos = pos.to3D(y);
            if (!StructHelper.isValidBuildingBlock(currPos, world)) continue;
            return y;
        }
        return null;
    }

    private static void scan(BlockPos2D center, Predicate<BlockPos2D> func) {
        BlockPos2D currPos;
        boolean flag;
        int i;
        boolean flag2 = func.test(center);
        if (!flag2) {
            return;
        }
        for (Direction d : MCHelper.NSWE) {
            for (i = 1; i <= 7 && (flag = func.test(currPos = center.offset(d, i))); ++i) {
            }
        }
        for (Direction d : MCHelper.NSWE) {
            for (i = 1; i <= 7 && (flag = func.test(currPos = center.offset(d, i).offset(d.func_176746_e(), i))); ++i) {
            }
        }
    }

    private static boolean isValidBuildingBlock(BlockPos pos, IWorld world) {
        BlockState block = world.func_180495_p(pos);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (!BlockTags.field_206952_E.func_199685_a_((Object)world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c())) continue;
                    return false;
                }
            }
        }
        if (Blocks.field_185774_da.equals(block.func_177230_c())) {
            return false;
        }
        if (BlockTags.field_206952_E.func_199685_a_((Object)block.func_177230_c())) {
            return false;
        }
        if (Blocks.field_150458_ak.equals(block.func_177230_c())) {
            return true;
        }
        if (Tags.Blocks.DIRT.func_199685_a_((Object)block.func_177230_c())) {
            return false;
        }
        if (Tags.Blocks.SAND.func_199685_a_((Object)block.func_177230_c())) {
            return false;
        }
        if (Blocks.field_196706_do.equals(block.func_177230_c())) {
            return false;
        }
        if (Blocks.field_150420_aW.equals(block.func_177230_c())) {
            return false;
        }
        if (Blocks.field_150419_aX.equals(block.func_177230_c())) {
            return false;
        }
        if (MCHelper.isSolid(block)) {
            return true;
        }
        if (Tags.Blocks.GLASS.func_199685_a_((Object)block.func_177230_c())) {
            return true;
        }
        if (Tags.Blocks.GLASS_PANES.func_199685_a_((Object)block.func_177230_c())) {
            return true;
        }
        if (BlockTags.field_203292_x.func_199685_a_((Object)block.func_177230_c())) {
            return true;
        }
        if (BlockTags.field_203291_w.func_199685_a_((Object)block.func_177230_c())) {
            return true;
        }
        if (BlockTags.field_200029_f.func_199685_a_((Object)block.func_177230_c())) {
            return true;
        }
        if (BlockTags.field_219748_G.func_199685_a_((Object)block.func_177230_c())) {
            return true;
        }
        return BlockTags.field_219757_z.func_199685_a_((Object)block.func_177230_c());
    }

    public static Condition alwaysAboveWater(DependencyInjector di, int radius) {
        return ConditionHelper.onlyInHeight(di, radius, new Interval(64.0, Double.POSITIVE_INFINITY));
    }
}

