/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import net.minecraftforge.common.IPlantable;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class JungleBigGen
extends TreeGenBase {
    private static final BlockState LOG = Blocks.field_196620_N.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196648_Z.func_176223_P();
    private static final IPlantable SAPLING = (IPlantable)Blocks.field_196678_w;

    public JungleBigGen(DependencyInjector di) {
        super(di, "infinibiome:jungleBig");
        this.config = this.initConfig().setFeature(new MegaJungleFeatureFixed()).setConfigFunc((pos, height, random) -> new HugeTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LOG), (BlockStateProvider)new SimpleBlockStateProvider(LEAF)).func_225569_d_(height + 1).setSapling(SAPLING).func_225568_b_()).setHeightFunc(15, 45).setIsolationRadius(3).onlyGrowIn2x2Config().setWithCommonDensity().setRegionRate(1.0).addExtraConditions(ConditionHelper.onlyInTemperature(di, PosDataHelper.HOT_INTERVAL), ConditionHelper.onlyInHumidity(di, PosDataHelper.WET_INTERVAL));
    }

    private static class MegaJungleFeatureFixed
    extends HugeTreesFeature<HugeTreeFeatureConfig> {
        MegaJungleFeatureFixed() {
            super(HugeTreeFeatureConfig::deserializeJungle);
        }

        public boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBoxIn, HugeTreeFeatureConfig configIn) {
            int i = this.func_227256_a_(rand, configIn);
            if (!this.hasRoom(generationReader, positionIn, i, (BaseTreeFeatureConfig)configIn)) {
                return false;
            }
            this.func_227252_c_(generationReader, rand, positionIn.func_177981_b(i), 2, p_225557_5_, boundingBoxIn, (BaseTreeFeatureConfig)configIn);
            for (int j = positionIn.func_177956_o() + i - 2 - rand.nextInt(4); j > positionIn.func_177956_o() + i / 2; j -= 2 + rand.nextInt(4)) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                int k = positionIn.func_177958_n() + (int)(0.5f + MathHelper.func_76134_b((float)f) * 4.0f);
                int l = positionIn.func_177952_p() + (int)(0.5f + MathHelper.func_76126_a((float)f) * 4.0f);
                for (int i1 = 0; i1 < 5; ++i1) {
                    k = positionIn.func_177958_n() + (int)(1.5f + MathHelper.func_76134_b((float)f) * (float)i1);
                    l = positionIn.func_177952_p() + (int)(1.5f + MathHelper.func_76126_a((float)f) * (float)i1);
                    BlockPos blockpos = new BlockPos(k, j - 3 + i1 / 2, l);
                    this.func_227216_a_(generationReader, rand, blockpos, p_225557_4_, boundingBoxIn, (BaseTreeFeatureConfig)configIn);
                }
                int l1 = 1 + rand.nextInt(2);
                int i2 = j;
                for (int j1 = j - l1; j1 <= i2; ++j1) {
                    int k1 = j1 - i2;
                    this.func_227257_b_(generationReader, rand, new BlockPos(k, j1, l), 1 - k1, p_225557_5_, boundingBoxIn, (BaseTreeFeatureConfig)configIn);
                }
            }
            this.func_227254_a_(generationReader, rand, positionIn, i, p_225557_4_, boundingBoxIn, configIn);
            return true;
        }

        private void func_227252_c_(IWorldGenerationReader p_227252_1_, Random p_227252_2_, BlockPos p_227252_3_, int p_227252_4_, Set<BlockPos> p_227252_5_, MutableBoundingBox p_227252_6_, BaseTreeFeatureConfig p_227252_7_) {
            int i = 2;
            for (int j = -2; j <= 0; ++j) {
                this.func_227255_a_(p_227252_1_, p_227252_2_, p_227252_3_.func_177981_b(j), p_227252_4_ + 1 - j, p_227252_5_, p_227252_6_, p_227252_7_);
            }
        }

        protected int func_227256_a_(Random p_227256_1_, HugeTreeFeatureConfig p_227256_2_) {
            int i = p_227256_2_.field_227371_p_;
            if (p_227256_2_.field_227275_a_ > 1) {
                i += p_227256_1_.nextInt(p_227256_2_.field_227275_a_);
            }
            return i;
        }
    }
}

