/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import net.minecraftforge.common.IPlantable;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeHelper;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class SpruceBigGen
extends TreeGenBase {
    private static final BlockState LOG = Blocks.field_196618_L.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196645_X.func_176223_P();
    private static final IPlantable SAPLING = (IPlantable)Blocks.field_196675_u;
    private final FloatFunc<BlockPos2D> ratioFunc;

    public SpruceBigGen(DependencyInjector di) {
        super(di, "infinibiome:spruceBig");
        this.config = this.initConfig().setFeature(new MegaPineTreeFixed()).setConfigFunc(this::getConfig).setHeightFunc(15, 45).setIsolationRadius(3).onlyGrowIn2x2Config().setWithCommonDensity().setRegionRate(0.25).addExtraConditions(ConditionHelper.onlyInTemperature(di, GenHelper.COLDISH), new Condition[0]);
        this.ratioFunc = TreeHelper.initSpruceRatioNoise(this.seed);
    }

    private HugeTreeFeatureConfig getConfig(BlockPos2D pos, int height, Random random) {
        double ratio = this.ratioFunc.getOutput(pos);
        if (weightedgpa.infinibiome.internal.misc.MathHelper.randomBool(ratio, random)) {
            return new HugeTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LOG), (BlockStateProvider)new SimpleBlockStateProvider(LEAF)).func_225569_d_(height + 1).func_227284_c_(3).setSapling((IPlantable)Blocks.field_196675_u).func_225568_b_();
        }
        return new HugeTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LOG), (BlockStateProvider)new SimpleBlockStateProvider(LEAF)).func_225569_d_(height + 1).func_227284_c_(12).setSapling(SAPLING).func_225568_b_();
    }

    public class MegaPineTreeFixed
    extends HugeTreesFeature<HugeTreeFeatureConfig> {
        public MegaPineTreeFixed() {
            super(HugeTreeFeatureConfig::deserializeSpruce);
        }

        public boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBoxIn, HugeTreeFeatureConfig configIn) {
            int i = this.func_227256_a_(rand, configIn);
            if (!this.hasRoom(generationReader, positionIn, i, (BaseTreeFeatureConfig)configIn)) {
                return false;
            }
            this.func_227253_a_(generationReader, rand, positionIn.func_177958_n(), positionIn.func_177952_p(), positionIn.func_177956_o() + i, 0, p_225557_5_, boundingBoxIn, configIn);
            this.func_227254_a_(generationReader, rand, positionIn, i, p_225557_4_, boundingBoxIn, configIn);
            return true;
        }

        private void func_227253_a_(IWorldGenerationReader p_227253_1_, Random p_227253_2_, int p_227253_3_, int p_227253_4_, int p_227253_5_, int p_227253_6_, Set<BlockPos> p_227253_7_, MutableBoundingBox p_227253_8_, HugeTreeFeatureConfig p_227253_9_) {
            int i = p_227253_2_.nextInt(5) + p_227253_9_.field_227276_b_;
            int j = 0;
            for (int k = p_227253_5_ - i; k <= p_227253_5_; ++k) {
                int l = p_227253_5_ - k;
                int i1 = p_227253_6_ + MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
                this.func_227255_a_(p_227253_1_, p_227253_2_, new BlockPos(p_227253_3_, k, p_227253_4_), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0), p_227253_7_, p_227253_8_, (BaseTreeFeatureConfig)p_227253_9_);
                j = i1;
            }
        }

        protected int func_227256_a_(Random p_227256_1_, HugeTreeFeatureConfig p_227256_2_) {
            int i = p_227256_2_.field_227371_p_;
            if (p_227256_2_.field_227275_a_ > 1) {
                i += p_227256_1_.nextInt(p_227256_2_.field_227275_a_);
            }
            return i;
        }
    }
}

