/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.PineFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.SpruceFoliagePlacer;
import net.minecraftforge.common.IPlantable;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeHelper;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class SpruceSmallGen
extends TreeGenBase {
    private static final BlockState LOG = Blocks.field_196618_L.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196645_X.func_176223_P();
    private static final IPlantable SAPLING = (IPlantable)Blocks.field_196675_u;
    private final FloatFunc<BlockPos2D> ratioFunc;
    private final Type type;

    public SpruceSmallGen(Type type, DependencyInjector di) {
        super(di, "infinibiome:spruceSmall" + type.name());
        this.type = type;
        this.config = this.initConfig().setFeature(Feature.field_202301_A).setConfigFunc(this::getConfig).setHeightFunc(6, 12).setIsolationRadius(3).onlyGrowIn1x1Config().setWithCommonDensity().setRegionRate(type.regionRate).addExtraConditions(type.conditions.apply(di));
        this.ratioFunc = TreeHelper.initSpruceRatioNoise(this.seed);
    }

    TreeFeatureConfig getConfig(BlockPos2D pos, int height, Random random) {
        double ratio = this.ratioFunc.getOutput(pos);
        boolean isPine = MathHelper.randomBool(ratio, random);
        if (isPine) {
            return new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LOG), (BlockStateProvider)new SimpleBlockStateProvider(LEAF), (FoliagePlacer)new PineFoliagePlacer(1, 0)).func_225569_d_(height + 1).func_227358_g_(1).func_227360_i_(3).func_227352_a_().setSapling((IPlantable)Blocks.field_196675_u).func_225568_b_();
        }
        return new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(LOG), (BlockStateProvider)new SimpleBlockStateProvider(LEAF), (FoliagePlacer)new SpruceFoliagePlacer(2, 1)).func_225569_d_(height).func_227356_e_(1).func_227352_a_().setSapling(SAPLING).func_225568_b_();
    }

    public String toString() {
        return "SpruceSmallGen{type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        NORMAL(0.5, di -> Lists.newArrayList((Object[])new Condition[]{ConditionHelper.onlyInTemperature(di, GenHelper.COLDISH)})),
        HOT(0.16666666666666666, di -> Lists.newArrayList((Object[])new Condition[]{ConditionHelper.onlyInTemperature(di, PosDataHelper.HOT_INTERVAL), ConditionHelper.onlyInHumidity(di, GenHelper.DRYISH)}));

        final double regionRate;
        final Function<DependencyInjector, List<Condition>> conditions;

        private Type(double regionRate, Function<DependencyInjector, List<Condition>> conditions) {
            this.regionRate = regionRate;
            this.conditions = conditions;
        }
    }
}

