/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IPlantable;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.minecraftImpl.world.WorldWrapper;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

final class TreeDensityCounter
extends WorldWrapper {
    private static final int INVALID_GROUND = -1;
    private static final int GROUND = 0;
    private static final int LEAF = 1;
    private final int[][] leafMap = new int[16][16];
    private final InterChunkPos interChunkPos;

    TreeDensityCounter(IWorld inner, InterChunkPos interChunkPos) {
        super(inner);
        this.interChunkPos = interChunkPos;
        interChunkPos.forEachCenterPos(pos2D -> {
            int leafHeight = MCHelper.getHighestY(pos2D, (IWorldReader)inner, b -> !b.func_177230_c().equals(Blocks.field_150433_aE));
            BlockPos leafPos = pos2D.to3D(leafHeight);
            if (BlockTags.field_206952_E.func_199685_a_((Object)inner.func_180495_p(leafPos).func_177230_c())) {
                this.setMap((BlockPos2D)pos2D, 1);
                return;
            }
            int groundHeight = MCHelper.getHighestTerrainHeight(pos2D, (IWorldReader)inner);
            BlockPos groundPos = pos2D.to3D(groundHeight);
            BlockState groundBlock = inner.func_180495_p(groundPos);
            if (!groundBlock.canSustainPlant((IBlockReader)inner, groundPos.func_177984_a(), Direction.DOWN, (IPlantable)Blocks.field_196674_t)) {
                this.setMap((BlockPos2D)pos2D, -1);
            }
        });
    }

    double getCurrentDensity() {
        int groundCount = 0;
        int leafCount = 0;
        int[][] nArray = this.leafMap;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int num : row = nArray[i]) {
                if (num == 0) {
                    ++groundCount;
                    continue;
                }
                if (num != 1) continue;
                ++leafCount;
            }
        }
        if (groundCount + leafCount <= 10) {
            return 0.0;
        }
        return (double)leafCount / (double)(groundCount + leafCount);
    }

    String debugInner() {
        String result = "\n";
        for (int[] row : this.leafMap) {
            result = result + Arrays.toString(row) + "\n";
        }
        return result;
    }

    @Override
    protected BlockState getBlock(BlockPos pos) {
        return this.inner.func_180495_p(pos);
    }

    @Override
    protected void setBlock(BlockPos pos, BlockState block, int tag) {
        if (BlockTags.field_206952_E.func_199685_a_((Object)block.func_177230_c())) {
            this.setMap(MCHelper.to2D(pos), 1);
        }
        this.inner.func_180501_a(pos, block, tag);
    }

    private void setMap(BlockPos2D pos, int num) {
        if (!this.interChunkPos.containsCenterPos(pos)) {
            return;
        }
        int x = Log2helper.mod(pos.getBlockX(), 4);
        int z = Log2helper.mod(pos.getBlockZ(), 4);
        this.leafMap[x][z] = num;
    }
}

