/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.Tags;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.PlantGrowthConfig;
import weightedgpa.infinibiome.api.generators.TreeGen;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.generators.nonworldgen.SaplingController;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.IntFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.NoPlantWrapper;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeHelper;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeHoldingWorld;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ClientUpdatingWorld;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.misc.Pair;

public abstract class TreeGenBase
extends GeneratorBase
implements TreeGen,
SaplingController,
Locatable.HasPointsProvider {
    Config<?> config;
    final PlantGrowthConfig growthConfig;

    TreeGenBase(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
        this.growthConfig = di.get(PlantGrowthConfig.class);
        DebugCommand.registerDebugFunc(seedBranch, "density", p -> this.getDensity(new InterChunkPos((BlockPos2D)p)));
        DebugCommand.registerDebugFunc(seedBranch, "rawDensity", p -> this.config.rawDensityFunc.getOutput((BlockPos2D)p));
        DebugCommand.registerDebugFunc(seedBranch, "conditions", p -> this.config.conditions._debug((BlockPos2D)p));
    }

    @Override
    public final double getDensity(InterChunkPos interChunkPos) {
        double result = 1.0;
        if ((result *= this.config.conditions.getAllProbability(interChunkPos, ConditionList.StrictOption.USE_LIKE_NON_STRICT)) == 0.0) {
            return 0.0;
        }
        return result *= this.config.rawDensityFunc.getOutput(interChunkPos.getLowestCenterBlockPos());
    }

    @Override
    public final boolean controlsPlant(BlockState block, boolean is2x2) {
        Block sapling = (Block)this.config.configFunc.get(new BlockPos2D(0, 0), 0, new Random()).getSapling();
        return sapling.equals(block.func_177230_c()) && this.config.is2x2.test(is2x2);
    }

    @Override
    public boolean isValidGrowth(BlockPos pos, IWorld world) {
        return this.isValidSpace(pos, world);
    }

    @Override
    public final boolean canGrowWithBonemeal(BlockPos pos, IWorld world, Random random) {
        if (this.growthConfig.allowSaplingUniformGrowth) {
            return true;
        }
        if (this.config.conditions.canBeHere(MCHelper.to2D(pos))) {
            return true;
        }
        return MathHelper.randomBool(0.25, random);
    }

    @Override
    public final void generate(BlockPos treePos, IWorld world) {
        this.tryGenerateTree(treePos, world, this.randomGen.getRandom(treePos.func_177958_n(), treePos.func_177952_p()), false);
    }

    @Override
    public final void growFromSapling(BlockPos pos, IWorld world, Random random) {
        this.tryGenerateTree(pos, new ClientUpdatingWorld(world), random, true);
    }

    private void tryGenerateTree(BlockPos treePos, IWorld world, Random random, boolean isSapling) {
        BlockPos2D treePos2D = MCHelper.to2D(treePos);
        if (!isSapling) {
            if (this.nearPathOrFence(treePos2D, (IWorldReader)world)) {
                return;
            }
            if (this.collidesWithOtherTree(treePos2D, (IWorldReader)world)) {
                return;
            }
        }
        int trunkHeight = this.config.heightFunc.getIntOutput(treePos2D);
        Object treeConfig = this.config.configFunc.get(treePos2D, trunkHeight, random);
        if (isSapling) {
            ((BaseTreeFeatureConfig)treeConfig).field_227372_q_ = true;
        }
        ChangeHoldingWorld worldWrapper = new ChangeHoldingWorld(new NoPlantWrapper(world));
        this.removeStoneOrGravel(treePos.func_177977_b(), worldWrapper);
        this.config.feature.func_212245_a((IWorld)worldWrapper, this.chunkGenerator, random, treePos, treeConfig);
        if (worldWrapper.changeCount() > 4) {
            worldWrapper.loadChange();
        }
        if (!isSapling) {
            TreeHelper.fixTwoByTwoTrees(treePos, world);
        }
        if (isSapling) {
            ((BaseTreeFeatureConfig)treeConfig).field_227372_q_ = false;
        }
    }

    private void removeStoneOrGravel(BlockPos groundPos, IWorld world) {
        if (groundPos.func_177956_o() != (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, MCHelper.to2D(groundPos))) {
            return;
        }
        if (!this.originallyDirt(MCHelper.to2D(groundPos))) {
            return;
        }
        world.func_180501_a(groundPos, Blocks.field_150346_d.func_176223_P(), 20);
    }

    private boolean originallyDirt(BlockPos2D pos) {
        List<BlockState> groundBlocks = this.posData.get(PosDataKeys.GROUND_BLOCKS, pos);
        if (groundBlocks.isEmpty()) {
            return false;
        }
        return groundBlocks.get(0).equals(Blocks.field_150346_d.func_176223_P());
    }

    private boolean nearPathOrFence(BlockPos2D pos, IWorldReader world) {
        for (int xOffset = -3; xOffset <= 3; ++xOffset) {
            for (int zOffset = -3; zOffset <= 3; ++zOffset) {
                BlockPos currGroundPos = pos.offset(xOffset, zOffset).to3D(p -> MCHelper.getHighestTerrainHeight(p, world));
                if (world.func_180495_p(currGroundPos).func_177230_c().equals(Blocks.field_185774_da)) {
                    return true;
                }
                if (!world.func_180495_p(currGroundPos.func_177984_a()).func_203425_a(Tags.Blocks.FENCES)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean collidesWithOtherTree(BlockPos2D pos, IWorldReader world) {
        int radius = this.config.isolationRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int checkHeight;
                BlockPos2D currPos2D = pos.offset(x, z);
                Block block = world.func_180495_p(currPos2D.to3D(checkHeight = MCHelper.getHighestTerrainHeight(currPos2D, world) + 1)).func_177230_c();
                if (!BlockTags.field_200031_h.func_199685_a_((Object)block)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidSpace(BlockPos pos, IWorld world) {
        Random random = new Random(0L);
        ChangeHoldingWorld changeHoldingWorld = new ChangeHoldingWorld(new NoPlantWrapper(world));
        this.tryGenerateTree(pos, changeHoldingWorld, random, true);
        return changeHoldingWorld.anyChange();
    }

    @Override
    public final void checkIsValid() {
        Validate.notNull(this.config);
    }

    @Override
    public final PointsProvider<BlockPos2D> getAllLocations() {
        return GenHelper.getCommonPredicateSearcher(32, false, this.config.conditions.add(new Condition.BoolInterpolated(){

            @Override
            public boolean passes(BlockPos2D pos) {
                double humidity = PosDataHelper.getHumidity(pos, TreeGenBase.this.posData);
                return !PosDataHelper.DRY_INTERVAL.contains(humidity);
            }
        }), this.posData);
    }

    <T extends BaseTreeFeatureConfig> Config.FeatureStep initConfig() {
        return new Config().new Config.FeatureStep();
    }

    class Config<T extends BaseTreeFeatureConfig> {
        Feature<T> feature;
        ConfigFunc<T> configFunc;
        IntFunc<BlockPos2D> heightFunc;
        Predicate<Boolean> is2x2;
        int isolationRadius;
        FloatFunc<BlockPos2D> rawDensityFunc;
        ConditionList conditions;

        private Config() {
            this.conditions = new ConditionList(ConditionHelper.onlyInMushroomIsland(TreeGenBase.this.di).invert(), ConditionHelper.onlyWhereInfibiomeGenAllowed(TreeGenBase.this.di));
        }

        class ConditionStep {
            ConditionStep() {
            }

            Config<?> addExtraConditions(Condition extraCondition0, Condition ... extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraCondition0);
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }

            Config<?> addExtraConditions(List<Condition> extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }

            Config<?> noExtraConditions() {
                return Config.this;
            }
        }

        class RegionStep {
            RegionStep() {
            }

            ConditionStep setRegionRate(double rate) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInRegion(TreeGenBase.this.seed, rate));
                return new ConditionStep();
            }
        }

        class DensityStep {
            DensityStep() {
            }

            RegionStep setWithCommonDensity() {
                return this.setDensity(TreeHelper.initCommonDensity(TreeGenBase.this.seed));
            }

            RegionStep setDensity(FloatFunc<BlockPos2D> density) {
                Config.this.rawDensityFunc = density;
                return new RegionStep();
            }
        }

        class _2x2Step {
            _2x2Step() {
            }

            DensityStep set2x2ConfigOption(Predicate<Boolean> is2x2) {
                Config.this.is2x2 = is2x2;
                return new DensityStep();
            }

            DensityStep onlyGrowIn2x2Config() {
                return this.set2x2ConfigOption(is2x2 -> is2x2);
            }

            DensityStep onlyGrowIn1x1Config() {
                return this.set2x2ConfigOption(is2x2 -> is2x2 == false);
            }

            DensityStep growInAnySaplingConfig() {
                return this.set2x2ConfigOption(is2x2 -> true);
            }
        }

        class IsolationStep {
            IsolationStep() {
            }

            _2x2Step setIsolationRadius(int radius) {
                Config.this.isolationRadius = radius;
                return new _2x2Step();
            }
        }

        class HeightStep {
            HeightStep() {
            }

            IsolationStep setHeightFunc(int min, int max) {
                Config.this.heightFunc = new RandomGen(TreeGenBase.this.seed).asPercentFloatFunc(BlockPos2D.INFO).mapToIntInterval(min, max);
                return new IsolationStep();
            }

            IsolationStep setHeightFunc(Pair<Integer, Integer> heightInterval) {
                return this.setHeightFunc((Integer)heightInterval.first, (Integer)heightInterval.second);
            }
        }

        class ConfigStep {
            ConfigStep() {
            }

            HeightStep setConfigFunc(ConfigFunc<T> configFunc_) {
                Config.this.configFunc = configFunc_;
                return new HeightStep();
            }
        }

        class FeatureStep {
            FeatureStep() {
            }

            ConfigStep setFeature(Feature<T> feature_) {
                Config.this.feature = feature_;
                return new ConfigStep();
            }
        }
    }

    static interface ConfigFunc<T extends BaseTreeFeatureConfig> {
        public T get(BlockPos2D var1, int var2, Random var3);
    }
}

