/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.generators.TreeGen;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeDensityCounter;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeHoldingWorld;
import weightedgpa.infinibiome.internal.minecraftImpl.world.SimulatedWorld;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class TreeGens
implements InterChunkGen {
    private static final int MAX_RETRIES = 16;
    private final RandomGen randomProducer;
    private final List<TreeGen> entries;

    public TreeGens(DependencyInjector di) {
        Seed seed = di.get(Seed.class).newSeed("infinibiome:treeGens");
        this.randomProducer = new RandomGen(seed);
        this.entries = di.getAll(TreeGen.class);
        DebugCommand.registerDebugFunc("tree", "density", p -> {
            InterChunkPos interChunkPos = new InterChunkPos((BlockPos2D)p);
            return String.valueOf(new TreeDensityCounter(new SimulatedWorld(di).simulateInterchunks(interChunkPos), interChunkPos).getCurrentDensity());
        });
        DebugCommand.registerDebugFunc("treeDensityCounter", "debug", p -> {
            InterChunkPos interChunkPos = new InterChunkPos((BlockPos2D)p);
            return new TreeDensityCounter(new SimulatedWorld(di).simulateInterchunks(interChunkPos), interChunkPos).debugInner();
        });
        DebugCommand.registerDebugFunc("tree", "funcDensity", p -> String.valueOf(this.getApproxDensity(new InterChunkPos((BlockPos2D)p))));
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.TREES;
    }

    public double getApproxDensity(InterChunkPos pos) {
        double result = 0.0;
        for (TreeGen treeGen : this.entries) {
            result += treeGen.getDensity(pos);
        }
        if (result > (double)0.9f) {
            return 0.9f;
        }
        return result;
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld world) {
        Random random = this.randomProducer.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        Map<TreeGen, DensityInfo> treesRemaining = this.getTreesToGenerate(interChunkPos);
        TreeDensityCounter wrapper1 = new TreeDensityCounter(world, interChunkPos);
        double currentTreeDensity = wrapper1.getCurrentDensity();
        while (!treesRemaining.isEmpty()) {
            boolean continuePlacingTree = false;
            TreeGen tree = this.pickRandomRemaining(treesRemaining, random);
            DensityInfo treeDensityInfo = treesRemaining.get(tree);
            for (int i = 0; i < 16; ++i) {
                BlockPos treePos = this.getRandomTreePos(interChunkPos, world, random);
                ChangeHoldingWorld wrapper2 = new ChangeHoldingWorld(wrapper1);
                tree.generate(treePos, wrapper2);
                if (wrapper2.anyChange()) {
                    double newTreeDensity = wrapper1.getCurrentDensity();
                    double gain = newTreeDensity - currentTreeDensity;
                    treeDensityInfo.addGain(gain);
                    if (treeDensityInfo.tooManyTrees(random)) {
                        continuePlacingTree = false;
                        break;
                    }
                    wrapper2.loadChange();
                    currentTreeDensity = newTreeDensity;
                    continuePlacingTree = true;
                    break;
                }
                continuePlacingTree = false;
            }
            if (continuePlacingTree) continue;
            treesRemaining.remove(tree);
        }
    }

    private TreeGen pickRandomRemaining(Map<TreeGen, ?> remainingTrees, Random random) {
        ArrayList<TreeGen> list = new ArrayList<TreeGen>(remainingTrees.keySet());
        return (TreeGen)list.get(random.nextInt(list.size()));
    }

    private BlockPos getRandomTreePos(InterChunkPos pos, IWorld world, Random random) {
        BlockPos2D treePos2D = pos.getRandomCenterPos(random);
        int treeHeight = MCHelper.getHighestTerrainHeight(treePos2D, (IWorldReader)world) + 1;
        return treePos2D.to3D(treeHeight);
    }

    private Map<TreeGen, DensityInfo> getTreesToGenerate(InterChunkPos pos) {
        HashMap<TreeGen, DensityInfo> result = new HashMap<TreeGen, DensityInfo>();
        double cumulative = 0.0;
        for (TreeGen treeGen : this.entries) {
            double density = treeGen.getDensity(pos);
            if (density == 0.0) continue;
            cumulative += density;
            result.put(treeGen, new DensityInfo(density));
        }
        if (cumulative > 0.95) {
            for (Map.Entry entry : new HashSet(result.entrySet())) {
                result.put((TreeGen)entry.getKey(), ((DensityInfo)entry.getValue()).fix(cumulative, 0.95));
            }
        }
        return result;
    }

    class Config {
        private FloatFunc<BlockPos2D> height;

        Config() {
        }
    }

    private static class DensityInfo {
        final double maxDensity;
        double currDensity = 0.0;
        int count = 0;

        DensityInfo(double density) {
            this.maxDensity = density;
        }

        DensityInfo fix(double cumulative, double maxCummulative) {
            return new DensityInfo(this.maxDensity / cumulative * maxCummulative);
        }

        void addGain(double gain) {
            this.currDensity += gain;
            ++this.count;
        }

        boolean tooManyTrees(Random random) {
            if (this.currDensity == 0.0) {
                return false;
            }
            double remaining = this.maxDensity - this.currDensity;
            double chance = remaining / this.getAvgTreeDensity();
            return !MathHelper.randomBool(chance = Interval.PERCENT.clamp(chance), random);
        }

        private double getAvgTreeDensity() {
            return this.currDensity / (double)this.count;
        }

        public String toString() {
            return "Density{currDensity=" + this.currDensity + ", maxDensity=" + this.maxDensity + '}';
        }
    }
}

