/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.tree;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.IntervalMapperWrapper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.Pair;

final class TreeHelper {
    static final double COMMON_REGION_RATE = 0.5;
    static final int COMMON_ISOLATION_RADIUS = 3;
    static final Pair<Integer, Integer> SMALL_TREE_HEIGHT = new Pair<Integer, Integer>(5, 8);

    private TreeHelper() {
    }

    static FloatFunc<BlockPos2D> initCommonDensity(Seed seed) {
        seed = seed.newSeed("density");
        return Helper.initUniformNoise(seed, 2048.0).skew(FloatFunc.constFunc(-5.0));
    }

    static FloatFunc<BlockPos2D> initSpruceRatioNoise(Seed seed) {
        seed = seed.newSeed("ratio");
        FloatFunc<BlockPos2D> base = Helper.initUniformNoise(seed, 2048.0);
        return new IntervalMapperWrapper<BlockPos2D>(base).addBranch(new Interval(0.0, 0.25), 0.0, 0.0).addBranch(new Interval(0.25, 0.75), 0.0, 1.0).addBranch(new Interval(0.75, 1.0), 1.0, 1.0);
    }

    static void fixTwoByTwoTrees(BlockPos pos, IWorld world) {
        for (int y = 1; y <= 3; ++y) {
            BlockPos currPos = pos.func_177979_c(y);
            if (!TreeHelper.canPlaceDirt(currPos, world)) continue;
            TreeHelper.placeDirt(currPos, world);
            break;
        }
    }

    private static boolean canPlaceDirt(BlockPos pos, IWorld world) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos currPos = pos.func_177982_a(x, 0, z);
                Block block = world.func_180495_p(currPos).func_177230_c();
                if (!block.equals(Blocks.field_196658_i) && !block.equals(Blocks.field_150346_d)) continue;
                return true;
            }
        }
        return false;
    }

    private static void placeDirt(BlockPos pos, IWorld world) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos currPos = pos.func_177982_a(x, 0, z);
                Block trunkBlock = world.func_180495_p(currPos.func_177984_a()).func_177230_c();
                if (!BlockTags.field_200031_h.func_199685_a_((Object)trunkBlock)) continue;
                world.func_180501_a(currPos, Blocks.field_150346_d.func_176223_P(), 20);
                TreeHelper.fixGrass(currPos.func_177977_b(), world);
            }
        }
    }

    private static void fixGrass(BlockPos pos, IWorld world) {
        if (!world.func_180495_p(pos).func_177230_c().equals(Blocks.field_196658_i)) {
            return;
        }
        world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 20);
    }
}

