/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.nonworldgen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.DependencyModule;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileConfig;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileSubConfig;
import weightedgpa.infinibiome.internal.dependency.DependencyInjectorImpl;

public final class FileConfigImpl
implements FileConfig {
    private final CommentedConfig config;

    public FileConfigImpl(DependencyInjector di) {
        try {
            this.config = new TomlParser().parse((Reader)new FileReader(FileConfigImpl.getReadFile(di.get(ServerWorld.class))));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public FileConfigImpl(List<DependencyModule> modules) {
        modules = new ArrayList<DependencyModule>(modules);
        this.config = CommentedConfig.wrap(new LinkedHashMap(), (ConfigFormat)TomlFormat.instance());
        modules.add(t -> t.addItem(FileConfigImpl.class, __ -> this));
        DependencyInjector di = new DependencyInjectorImpl(modules).initInjector();
        di.getAll(FileSubConfig.class);
    }

    private FileConfigImpl(CommentedConfig config) {
        this.config = config;
    }

    public static void refreshConfig(List<DependencyModule> depModules) {
        CommentedConfig defaultConfig = new FileConfigImpl(depModules).getRawConfig();
        new TomlWriter().write((UnmodifiableConfig)defaultConfig, FileConfigImpl.getPreConfigFile(), WritingMode.REPLACE);
    }

    public static void saveConfig(DependencyInjector di) {
        di.getAll(FileSubConfig.class);
        CommentedConfig config = di.get(FileConfig.class).getRawConfig();
        ServerWorld world = di.get(ServerWorld.class);
        new TomlWriter().write((UnmodifiableConfig)config, FileConfigImpl.getWorldConfigFile(world), WritingMode.REPLACE);
    }

    private static File getReadFile(ServerWorld serverWorld) {
        File worldConfigFile = FileConfigImpl.getWorldConfigFile(serverWorld);
        if (worldConfigFile.exists()) {
            return worldConfigFile;
        }
        return FileConfigImpl.getPreConfigFile();
    }

    private static File getWorldConfigFile(ServerWorld world) {
        return new File(world.func_217485_w().func_75765_b().getAbsolutePath() + File.separator + "serverconfig" + File.separator + "infinibiome_config.toml");
    }

    private static File getPreConfigFile() {
        return new File(FMLPaths.CONFIGDIR.get().toAbsolutePath() + File.separator + "infinibiome_preconfig.toml");
    }

    @Override
    public FileConfigImpl subConfig(String path) {
        if (!this.config.contains(path)) {
            this.config.add(path, (Object)CommentedConfig.wrap(new LinkedHashMap(), (ConfigFormat)TomlFormat.instance()));
        }
        return new FileConfigImpl((CommentedConfig)this.config.get(path));
    }

    @Override
    public int getInt(String path, int defaultValue, int minValue, int maxValue, String description) {
        int result;
        assert (minValue <= maxValue);
        assert (minValue <= defaultValue && defaultValue <= maxValue);
        if (!description.isEmpty()) {
            this.config.setComment(path, "\n" + description + "\n" + String.format("Default: %s", defaultValue) + "\n" + String.format("Range: %s ~ %s", minValue, maxValue));
        } else {
            this.config.setComment(path, "\n" + String.format("Default: %s", defaultValue) + "\n" + String.format("Range: %s ~ %s", minValue, maxValue));
        }
        try {
            result = this.config.getInt(path);
            if (result < minValue) {
                result = minValue;
            }
            if (result > maxValue) {
                result = maxValue;
            }
        }
        catch (Throwable e) {
            result = defaultValue;
        }
        this.config.set(path, (Object)result);
        return result;
    }

    @Override
    public double getFloat(String path, double defaultValue, double minValue, double maxValue, String description) {
        return this.getRelativeFloat(path, defaultValue, minValue, maxValue, 1.0, description);
    }

    @Override
    public double getRelativeFloat(String path, double defaultValue, double minValue, double maxValue, String description) {
        return this.getRelativeFloat(path, defaultValue, minValue, maxValue, defaultValue, description);
    }

    @Override
    public double getRelativeFloat(String path, double defaultValue, double minValue, double maxValue, double relative, String description) {
        double result;
        assert (minValue <= maxValue);
        assert (minValue <= defaultValue && defaultValue <= maxValue);
        assert (relative > 0.0);
        if (!description.isEmpty()) {
            this.config.setComment(path, "\n" + description + "\n" + String.format("Default: %s", defaultValue / relative) + "\n" + String.format("Range: %s ~ %s", minValue / relative, maxValue / relative));
        } else {
            this.config.setComment(path, "\n" + String.format("Default: %s", defaultValue / relative) + "\n" + String.format("Range: %s ~ %s", minValue / relative, maxValue / relative));
        }
        try {
            result = ((Number)this.config.get(path)).doubleValue();
            if (result < minValue / relative) {
                result = minValue / relative;
            }
            if (result > maxValue / relative) {
                result = maxValue / relative;
            }
        }
        catch (Throwable e) {
            result = defaultValue / relative;
        }
        this.config.set(path, (Object)result);
        return result * relative;
    }

    @Override
    public boolean getBool(String path, boolean defaultValue, String description) {
        boolean result;
        if (!description.isEmpty()) {
            this.config.setComment(path, "\n" + description + "\n" + String.format("Default: %s", defaultValue));
        } else {
            this.config.setComment(path, "\n" + String.format("Default: %s", defaultValue));
        }
        try {
            result = (Boolean)this.config.get(path);
        }
        catch (Throwable e) {
            result = defaultValue;
        }
        this.config.set(path, (Object)result);
        return result;
    }

    @Override
    public CommentedConfig getRawConfig() {
        return this.config;
    }
}

