/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.nonworldgen.controllers;

import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.GroundBoneMealController;
import weightedgpa.infinibiome.internal.minecraftImpl.IBWorldType;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeDetectingWorld;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeHoldingWorld;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class GroundBoneMealControllers {
    private static List<GroundBoneMealController> groundBoneMealControllers = null;

    private GroundBoneMealControllers() {
    }

    public static void refresh(DependencyInjector di) {
        groundBoneMealControllers = di.getAll(GroundBoneMealController.class);
    }

    @SubscribeEvent
    public static void onGroundBoneMeal(BonemealEvent e) {
        if (!(e.getWorld().func_175624_G() instanceof IBWorldType)) {
            return;
        }
        if (!GroundBoneMealControllers.isValidGroundToBonemeal(e.getPos(), e.getWorld())) {
            return;
        }
        if (e.getWorld().func_201670_d()) {
            e.setResult(Event.Result.ALLOW);
            return;
        }
        Random random = new Random();
        if (!GroundBoneMealControllers.somethingGeneratesHere(e.getPos().func_177984_a(), e.getWorld())) {
            e.setCanceled(true);
            return;
        }
        if (!MathHelper.randomBool(0.3333333333333333, random)) {
            e.setResult(Event.Result.ALLOW);
            return;
        }
        for (GroundBoneMealController g : Helper.shuffle(groundBoneMealControllers, random)) {
            double chance = g.getGroundBonemealChance(MCHelper.to2D(e.getPos()));
            if (chance > 1.0) {
                chance = 1.0;
            }
            if (MathHelper.randomBool(chance, random)) continue;
            ChangeDetectingWorld wrapper = new ChangeDetectingWorld((IWorld)e.getWorld());
            g.spawnFromGroundBoneMeal(e.getPos().func_177984_a(), wrapper, random);
            if (!wrapper.anyChange()) continue;
            break;
        }
        e.setResult(Event.Result.ALLOW);
    }

    private static boolean somethingGeneratesHere(BlockPos pos, World world) {
        ChangeHoldingWorld wrapper = new ChangeHoldingWorld((IWorld)world);
        Random random = new Random();
        for (GroundBoneMealController g : groundBoneMealControllers) {
            g.spawnFromGroundBoneMeal(pos, wrapper, random);
            if (!wrapper.anyChange()) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidGroundToBonemeal(BlockPos pos, World world) {
        if (!MCHelper.isSolid(world.func_180495_p(pos))) {
            return false;
        }
        return !MCHelper.isSolid(world.func_180495_p(pos.func_177984_a()));
    }
}

