/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.nonworldgen.controllers;

import java.util.List;
import java.util.Random;
import net.minecraft.block.IGrowable;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.PlantGrowthController;
import weightedgpa.infinibiome.internal.minecraftImpl.IBWorldType;

public final class PlantGrowthControllers {
    private static List<PlantGrowthController> plantGrowthControllers = null;

    public static void refresh(DependencyInjector di) {
        plantGrowthControllers = di.getAll(PlantGrowthController.class);
    }

    @SubscribeEvent
    public static void onTickGrowth(BlockEvent.CropGrowEvent.Pre e) {
        if (!(e.getWorld().func_201672_e().func_175624_G() instanceof IBWorldType)) {
            return;
        }
        Random random = new Random();
        PlantGrowthController.Result<PlantGrowthController> result = PlantGrowthController.getPlant(e.getPos(), e.getWorld(), random, plantGrowthControllers);
        if (result instanceof PlantGrowthController.Result.NOT_CONTROLLED) {
            return;
        }
        if (result instanceof PlantGrowthController.Result.INVALID_GROWTH) {
            e.setResult(Event.Result.DENY);
            return;
        }
        PlantGrowthController controller = (PlantGrowthController)((PlantGrowthController.Result.OK)result).controller;
        if (!controller.canGrowWithTick(e.getPos(), e.getWorld(), random)) {
            e.setResult(Event.Result.DENY);
            return;
        }
        e.setResult(Event.Result.DEFAULT);
    }

    @SubscribeEvent
    public static void onBoneMeal(BonemealEvent e) {
        if (!(e.getWorld().func_175624_G() instanceof IBWorldType)) {
            return;
        }
        if (!(e.getBlock().func_177230_c() instanceof IGrowable)) {
            return;
        }
        if (e.getWorld().func_201670_d()) {
            e.setResult(Event.Result.ALLOW);
            return;
        }
        Random random = new Random();
        PlantGrowthController.Result<PlantGrowthController> result = PlantGrowthController.getPlant(e.getPos(), (IWorld)e.getWorld(), random, plantGrowthControllers);
        if (result instanceof PlantGrowthController.Result.NOT_CONTROLLED) {
            return;
        }
        if (result instanceof PlantGrowthController.Result.INVALID_GROWTH) {
            e.setCanceled(true);
            return;
        }
        PlantGrowthController controller = (PlantGrowthController)((PlantGrowthController.Result.OK)result).controller;
        if (!controller.canGrowWithBonemeal(e.getPos(), (IWorld)e.getWorld(), random)) {
            e.setResult(Event.Result.ALLOW);
            return;
        }
        e.setResult(Event.Result.DEFAULT);
    }
}

