/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.nonworldgen.controllers;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.PlantGrowthController;
import weightedgpa.infinibiome.api.generators.nonworldgen.SaplingController;
import weightedgpa.infinibiome.internal.minecraftImpl.IBWorldType;

public final class SaplingControllers {
    private static List<SaplingController> saplingControllers = null;

    private SaplingControllers() {
    }

    public static void refresh(DependencyInjector di) {
        saplingControllers = di.getAll(SaplingController.class);
    }

    @SubscribeEvent
    public static void onSaplingGrowEvent(SaplingGrowTreeEvent e) {
        if (!(e.getWorld().func_201672_e().func_175624_G() instanceof IBWorldType)) {
            return;
        }
        Random random = new Random();
        PlantGrowthController.Result<SaplingController> result = PlantGrowthController.getPlant(e.getPos(), e.getWorld(), random, saplingControllers);
        if (result instanceof PlantGrowthController.Result.NOT_CONTROLLED) {
            return;
        }
        if (result instanceof PlantGrowthController.Result.INVALID_GROWTH) {
            e.setResult(Event.Result.DENY);
            return;
        }
        SaplingController controller = (SaplingController)((PlantGrowthController.Result.OK)result).controller;
        if (!controller.canGrowWithTick(e.getPos(), e.getWorld(), random)) {
            e.setResult(Event.Result.DENY);
            return;
        }
        controller.growFromSapling(SaplingControllers.fix2x2Pos(e.getPos(), (IWorldReader)e.getWorld()), e.getWorld(), random);
        e.setResult(Event.Result.DENY);
    }

    private static BlockPos fix2x2Pos(BlockPos pos, IWorldReader world) {
        BlockPos[] posList;
        Block originalSapling = world.func_180495_p(pos).func_177230_c();
        for (BlockPos checkPos : posList = new BlockPos[]{pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.WEST), pos.func_177972_a(Direction.NORTH), pos.func_177972_a(Direction.WEST)}) {
            if (!world.func_180495_p(checkPos).func_177230_c().equals(originalSapling)) continue;
            return checkPos;
        }
        return pos;
    }
}

