/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.nonworldgen.spawnList;

import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.MobSpawnListModifier;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class MonsterSpawnList
implements MobSpawnListModifier {
    private final PosDataProvider posData;

    public MonsterSpawnList(DependencyInjector di) {
        this.posData = di.get(PosDataProvider.class);
    }

    @Override
    public void modifyList(BlockPos pos, EntityClassification creatureType, List<Biome.SpawnListEntry> spawnListEntries, IWorld world) {
        if (creatureType != EntityClassification.MONSTER) {
            return;
        }
        BlockPos2D pos2D = MCHelper.to2D(pos);
        if (this.posData.get(PosDataKeys.IS_MUSHROOM_ISLAND, pos2D).booleanValue()) {
            return;
        }
        double temperature = PosDataHelper.getTemperature(pos, this.posData);
        double humidity = PosDataHelper.getHumidity(pos, this.posData);
        spawnListEntries.add(new Biome.SpawnListEntry(this.getZombieType(humidity), 100, 5, 5));
        spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200748_an, 100, 5, 5));
        spawnListEntries.add(new Biome.SpawnListEntry(this.getSkeletonType(temperature), 100, 1, 1));
        spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200727_aF, 5, 1, 1));
        spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200797_k, 100, 1, 1));
        spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200803_q, 10, 1, 1));
        boolean isWet = PosDataHelper.WET_INTERVAL.contains(humidity);
        boolean isOcean = this.posData.get(PosDataKeys.LANDMASS_TYPE, pos2D).isOcean();
        boolean isLakeOrRiver = PosDataHelper.isUnderwaterPortionOfLakeOrRiver(pos2D, this.posData);
        if (isWet) {
            spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200743_ai, 100, 1, 1));
            spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200759_ay, 5, 1, 1));
        }
        if (isOcean) {
            spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_200761_A, 1, 1, 1));
        }
        if (isLakeOrRiver || isOcean) {
            spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_204724_o, 1000, 5, 5));
        }
    }

    private EntityType<?> getZombieType(double humidity) {
        if (PosDataHelper.DRY_INTERVAL.contains(humidity)) {
            return EntityType.field_200763_C;
        }
        return EntityType.field_200725_aD;
    }

    private EntityType<?> getSkeletonType(double temperature) {
        if (PosDataHelper.FREEZE_INTERVAL.contains(temperature)) {
            return EntityType.field_200750_ap;
        }
        return EntityType.field_200741_ag;
    }
}

