/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.nonworldgen.spawnList;

import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.MobSpawnListModifier;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class RiverLakeSpawnList
implements MobSpawnListModifier {
    private final PosDataProvider data;

    public RiverLakeSpawnList(DependencyInjector di) {
        this.data = di.get(PosDataProvider.class);
    }

    @Override
    public void modifyList(BlockPos pos, EntityClassification creatureType, List<Biome.SpawnListEntry> spawnListEntries, IWorld world) {
        if (creatureType != EntityClassification.WATER_CREATURE) {
            return;
        }
        if (!PosDataHelper.isUnderwaterPortionOfLakeOrRiver(MCHelper.to2D(pos), this.data)) {
            return;
        }
        spawnListEntries.add(new Biome.SpawnListEntry(EntityType.field_203778_ae, 1, 1, 1));
    }
}

