/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;

public enum GroundBlocks {
    DIRT(Blocks.field_150346_d.func_176223_P(), 2, 4),
    GRAVEL(Blocks.field_150351_n.func_176223_P(), 2, 4),
    SAND(Blocks.field_150354_m.func_176223_P(), 2, 4, Blocks.field_150322_A.func_176223_P(), 2, 4),
    STONE(Blocks.field_150348_b.func_176223_P(), 2, 4);

    private static final RandomGen randomProducer;
    private final List<List<BlockState>> blockChoices = new ArrayList<List<BlockState>>();

    private GroundBlocks(BlockState block, int min, int max) {
        this(block, min, max, block, 0, 0);
    }

    private GroundBlocks(BlockState block1, int min1, int max1, BlockState block2, int min2, int max2) {
        for (int block1Count = min1; block1Count <= max1; ++block1Count) {
            for (int block2Count = min2; block2Count <= max2; ++block2Count) {
                ArrayList<BlockState> blocks = new ArrayList<BlockState>();
                blocks.addAll(Collections.unmodifiableCollection(Collections.nCopies(block1Count, block1)));
                blocks.addAll(Collections.unmodifiableCollection(Collections.nCopies(block2Count, block2)));
                this.blockChoices.add(blocks);
            }
        }
    }

    public final List<BlockState> getSurfaceBlocks(BlockPos2D pos) {
        Random randomFromPos = randomProducer.getRandom(pos.getBlockX(), pos.getBlockZ());
        int randomIndex = randomFromPos.nextInt(this.blockChoices.size());
        return this.blockChoices.get(randomIndex);
    }

    private List<BlockState> repeatBlocks(@Nullable BlockState block, int amount) {
        if (block == null) {
            return Collections.emptyList();
        }
        return Collections.nCopies(amount, block);
    }

    static {
        randomProducer = new RandomGen(Seed.ROOT.newSeed("surfaceBlocks"));
    }
}

