/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.ClimateConfig;
import weightedgpa.infinibiome.api.generators.PosDataTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataTable;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.PerlinNoise;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.IntervalMapperWrapper;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.SeamlessGrid;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.posdata.DataGeneratorBase;
import weightedgpa.infinibiome.internal.generators.posdata.GroundBlocks;
import weightedgpa.infinibiome.internal.generators.posdata.HeightMapProducer;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.misc.PregeneratedSeamlessGrid;

public final class HeightGen
extends DataGeneratorBase {
    private final Land land;
    private final Beach beach;
    private final Ocean ocean;
    private final ClimateConfig climateConfig;

    public HeightGen(DependencyInjector di) {
        super(di, "infinibiome:heightGen", PosDataTimings.HEIGHT);
        this.ocean = new Ocean(this.seed);
        this.beach = new Beach(this.seed);
        this.land = new Land(this.seed);
        this.climateConfig = di.get(ClimateConfig.class);
    }

    @Override
    public void generateData(PosDataTable data) {
        LandmassInfo landmassType = data.get(PosDataKeys.LANDMASS_TYPE);
        if (landmassType.isLand()) {
            this.land.modifyDataOutput(data, landmassType.getTransitionToBeach());
        } else if (landmassType.isBeach()) {
            this.beach.modifyDataOutput(data, ((LandmassInfo.Beach)landmassType).getTransitionToLand());
        } else {
            assert (landmassType.isOcean());
            this.ocean.modifyDataOutput(data, landmassType.getTransitionToBeach());
        }
    }

    class Beach {
        private final Interval BEACH_HEIGHT = new Interval(0.0, 5.0);
        private final Interval EASE = new Interval(2.0, 10.0);
        private final FloatFunc<BlockPos2D> heightAboveSeaFunc;
        private final Predicate<BlockPos2D> isGravelBeachFunc;
        private final Predicate<BlockPos2D> isStoneBeachFunc;
        private final FloatFunc<BlockPos2D> easeFunc;

        Beach(Seed seed) {
            seed = seed.newSeed("beach");
            this.heightAboveSeaFunc = this.initHeightAboveSeaFunc(seed);
            this.easeFunc = this.initEaseFunc(seed);
            this.isGravelBeachFunc = this.beachTypeTemplate(seed.newSeed("gravelBeach"));
            this.isStoneBeachFunc = this.beachTypeTemplate(seed.newSeed("stoneBeach"));
        }

        private FloatFunc<BlockPos2D> initHeightAboveSeaFunc(Seed seed) {
            seed = seed.newSeed("heightAboveSea");
            return new PerlinNoise<BlockPos2D>(seed, 2048.0, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE).mapInterval(this.BEACH_HEIGHT)._setDebuggable("beach", "heightAboveSea", p -> p);
        }

        private FloatFunc<BlockPos2D> initEaseFunc(Seed seed) {
            seed = seed.newSeed("ease");
            return new PerlinNoise<BlockPos2D>(seed, 2048.0, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE).mapInterval(this.EASE)._setDebuggable("beach", "ease", p -> p);
        }

        private Predicate<BlockPos2D> beachTypeTemplate(Seed seed) {
            seed = seed.newSeed("beachType");
            return new IntervalMapperWrapper(new PerlinNoise<BlockPos2D>(seed, 2048.0, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE)).addBranch(new Interval(0.0, 0.05f), 1.0, 1.0).addBranch(new Interval(0.05f, 0.06f), 1.0, 0.0).randomBool(BlockPos2D.INFO, seed);
        }

        void modifyDataOutput(PosDataTable dataTable, double transitionToLand) {
            transitionToLand = MathHelper.ease(transitionToLand, this.easeFunc.getOutput(dataTable.getPos()));
            dataTable.set(PosDataKeys.MAPPED_HEIGHT, this.getHeight(dataTable.getPos(), transitionToLand));
            dataTable.set(PosDataKeys.AMP, this.getAmp(dataTable.getPos()));
            dataTable.set(PosDataKeys.GROUND_BLOCKS, () -> this.getGroundBlocks(dataTable.getPos()));
        }

        double getHeight(BlockPos2D pos, double percentTowardsLand) {
            return MathHelper.lerp(percentTowardsLand, 63.0, this.heightAboveSeaFunc.getOutput(pos) + 63.0);
        }

        double getAmp(BlockPos2D pos) {
            return this.heightAboveSeaFunc.getOutput(pos);
        }

        List<BlockState> getGroundBlocks(BlockPos2D pos) {
            boolean isStoneBeach = this.isStoneBeachFunc.test(pos);
            boolean isGravelBeach = this.isGravelBeachFunc.test(pos);
            if (!isStoneBeach && !isGravelBeach) {
                return GroundBlocks.SAND.getSurfaceBlocks(pos);
            }
            if (isStoneBeach && !isGravelBeach) {
                return GroundBlocks.STONE.getSurfaceBlocks(pos);
            }
            if (!isStoneBeach && isGravelBeach) {
                return GroundBlocks.GRAVEL.getSurfaceBlocks(pos);
            }
            assert (isStoneBeach && isGravelBeach);
            Random random = HeightGen.this.randomGen.getRandom(pos.getBlockX(), pos.getBlockZ());
            return MathHelper.randomBool(0.5, random) ? GroundBlocks.GRAVEL.getSurfaceBlocks(pos) : GroundBlocks.STONE.getSurfaceBlocks(pos);
        }
    }

    class Ocean {
        private final Interval BASE_HEIGHT_BELOW_SEA_LEVEl = new Interval(5.0, 35.0);
        private final Interval AMP = new Interval(-20.0, -5.0);
        private final Interval EASE = new Interval(2.0, 10.0);
        private final Interval TRANSITION_TO_DEEP_SEA = new Interval(38.0, 33.0);
        private final HeightMapProducer heightMapProducer;
        private final FloatFunc<BlockPos2D> easeFunc;

        Ocean(Seed seed) {
            seed = seed.newSeed("ocean");
            this.heightMapProducer = new HeightMapProducer(seed, this.initBaseHeight(seed), this.initAmp(seed))._setDebuggable("ocean");
            this.easeFunc = this.initEaseFunc(seed);
        }

        private FloatFunc<BlockPos2D> initBaseHeight(Seed seed) {
            seed = seed.newSeed("baseHeight");
            return Helper.initUniformNoise(seed, 2048.0).mapInterval(this.BASE_HEIGHT_BELOW_SEA_LEVEl.applyOp(n -> 63.0 - n));
        }

        private FloatFunc<BlockPos2D> initAmp(Seed seed) {
            seed = seed.newSeed("amp");
            return Helper.initUniformNoise(seed, 2048.0).mapInterval(this.AMP);
        }

        private FloatFunc<BlockPos2D> initEaseFunc(Seed seed) {
            seed = seed.newSeed("ease");
            return Helper.initUniformNoise(seed, 2048.0).mapInterval(this.EASE)._setDebuggable("ocean", "transitionEase", p -> p);
        }

        void modifyDataOutput(PosDataTable dataOutput, double transitionToBeach) {
            transitionToBeach = MathHelper.ease(transitionToBeach, this.easeFunc.getOutput(dataOutput.getPos()));
            dataOutput.set(PosDataKeys.MAPPED_HEIGHT, this.getHeight(dataOutput.getPos(), transitionToBeach));
            dataOutput.set(PosDataKeys.AMP, this.getAmp(dataOutput.getPos(), transitionToBeach));
            dataOutput.set(PosDataKeys.GROUND_BLOCKS, () -> this.getGroundBlocks(dataOutput));
        }

        private double getHeight(BlockPos2D pos, double transitionToBeach) {
            double oceanHeight = this.heightMapProducer.getMappedHeight(pos);
            return transitionToBeach == 0.0 ? oceanHeight : MathHelper.lerp(transitionToBeach, oceanHeight, HeightGen.this.beach.getHeight(pos, 0.0));
        }

        private double getAmp(BlockPos2D pos, double transitionToBeach) {
            double oceanAmp = this.heightMapProducer.getAmp(pos);
            return transitionToBeach == 0.0 ? oceanAmp : MathHelper.lerp(transitionToBeach, oceanAmp, HeightGen.this.beach.getAmp(pos));
        }

        private List<BlockState> getGroundBlocks(PosDataTable posDataTable) {
            Random random;
            double height = posDataTable.get(PosDataKeys.MAPPED_HEIGHT);
            if (height > this.TRANSITION_TO_DEEP_SEA.getMax()) {
                return HeightGen.this.beach.getGroundBlocks(posDataTable.getPos());
            }
            if (height < this.TRANSITION_TO_DEEP_SEA.getMin()) {
                return GroundBlocks.GRAVEL.getSurfaceBlocks(posDataTable.getPos());
            }
            double chanceAsDeepSea = 1.0 - this.TRANSITION_TO_DEEP_SEA.mapInterval(height, Interval.PERCENT);
            return MathHelper.randomBool(chanceAsDeepSea, random = HeightGen.this.randomGen.getRandom(posDataTable.getPos().getBlockX(), posDataTable.getPos().getBlockZ())) ? GroundBlocks.GRAVEL.getSurfaceBlocks(posDataTable.getPos()) : HeightGen.this.beach.getGroundBlocks(posDataTable.getPos());
        }
    }

    class Land {
        private final Interval AMP = new Interval(5.0, 100.0);
        private final Interval BASE_HEIGHT_ABOVE_SEA = new Interval(0.0, 20.0);
        private final Interval TRANSITION_EASE = new Interval(2.0, 10.0);
        private final HeightMapProducer heightMapProducer;
        private final FloatFunc<BlockPos2D> transitionEase;

        Land(Seed seed) {
            seed = seed.newSeed("land");
            FloatFunc<BlockPos2D> ampFunc = this.initAmp(seed);
            this.heightMapProducer = new HeightMapProducer(seed, FloatFunc.constFunc(63.0), ampFunc).setRelativeScale(this.initRelativeScale(seed, ampFunc))._setDebuggable("land");
            this.transitionEase = this.initEaseFunc(seed);
        }

        private FloatFunc<BlockPos2D> initBaseHeight(Seed seed) {
            seed = seed.newSeed("baseHeight");
            return Helper.initUniformNoise(seed, 2048.0).skew(FloatFunc.constFunc(-5.0)).mapInterval(this.BASE_HEIGHT_ABOVE_SEA.applyOp(v -> v + 63.0));
        }

        private FloatFunc<BlockPos2D> initAmp(Seed seed) {
            seed = seed.newSeed("amp");
            return Helper.initUniformNoise(seed, 4096.0).skew(FloatFunc.constFunc(-20.0)).mapInterval(this.AMP);
        }

        private FloatFunc<BlockPos2D> initRelativeScale(Seed seed, final FloatFunc<BlockPos2D> ampFunc) {
            seed = seed.newSeed("relativeScale");
            final FloatFunc<BlockPos2D> scalePercent = Helper.initUniformNoise(seed, 2048.0);
            scalePercent.mapInterval(Interval.PERCENT)._setDebuggable("landScale", "scalePercent", (t, p) -> {
                SeamlessGrid var10000 = PregeneratedSeamlessGrid.TABLE_256_256;
                t.getClass();
                return var10000._debugValue((BlockPos2D)p, t::getOutput);
            });
            new FloatFunc<BlockPos2D>(){

                @Override
                public double getOutput(BlockPos2D input) {
                    return Land.this.getRelativeScaleMin(ampFunc.getOutput(input));
                }
            }._setDebuggable("landScale", "min", (t, p) -> {
                SeamlessGrid var10000 = PregeneratedSeamlessGrid.TABLE_256_256;
                t.getClass();
                return var10000._debugValue((BlockPos2D)p, t::getOutput);
            });
            new FloatFunc<BlockPos2D>(){

                @Override
                public double getOutput(BlockPos2D input) {
                    return Land.this.getRelativeScaleMax(ampFunc.getOutput(input));
                }
            }._setDebuggable("landScale", "max", (t, p) -> {
                SeamlessGrid var10000 = PregeneratedSeamlessGrid.TABLE_256_256;
                t.getClass();
                return var10000._debugValue((BlockPos2D)p, t::getOutput);
            });
            ampFunc._setDebuggable("landScale", "amp", (t, p) -> {
                SeamlessGrid var10000 = PregeneratedSeamlessGrid.TABLE_256_256;
                t.getClass();
                return var10000._debugValue((BlockPos2D)p, t::getOutput);
            });
            return new FloatFunc<BlockPos2D>(){

                @Override
                public double getOutput(BlockPos2D input) {
                    double amp = ampFunc.getOutput(input);
                    Interval interval = new Interval(Land.this.getRelativeScaleMin(amp), Land.this.getRelativeScaleMax(amp));
                    return scalePercent.getOutputInterval().mapInterval(scalePercent.getOutput(input), interval);
                }

                @Override
                public Interval getOutputInterval() {
                    return new Interval(1.0, 15.0);
                }
            }._setDebuggable("landScale", "scale", (t, p) -> {
                SeamlessGrid var10000 = PregeneratedSeamlessGrid.TABLE_256_256;
                t.getClass();
                return var10000._debugValue((BlockPos2D)p, t::getOutput);
            });
        }

        private double getRelativeScaleMin(double amp) {
            return -0.042105263157894736 * amp + 5.2105263157894735;
        }

        private double getRelativeScaleMax(double amp) {
            return -0.1368421052631579 * amp + 15.68421052631579;
        }

        private FloatFunc<BlockPos2D> initEaseFunc(Seed seed) {
            seed = seed.newSeed("ease");
            return Helper.initUniformNoise(seed, 2048.0).mapInterval(this.TRANSITION_EASE)._setDebuggable("landmass", "landTransitionEase", p -> p);
        }

        void modifyDataOutput(PosDataTable dataTable, double transitionToBeach) {
            MathHelper.ease(transitionToBeach, this.transitionEase.getOutput(dataTable.getPos()));
            dataTable.set(PosDataKeys.MAPPED_HEIGHT, this.getHeight(dataTable.getPos(), transitionToBeach));
            dataTable.set(PosDataKeys.AMP, this.getAmp(dataTable.getPos(), transitionToBeach));
            dataTable.set(PosDataKeys.GROUND_BLOCKS, () -> this.getLandGroundBlocks(dataTable));
        }

        private List<BlockState> getLandGroundBlocks(PosDataTable data) {
            double humidity = data.get(PosDataKeys.HUMIDITY).fromHeight(data.get(PosDataKeys.MAPPED_HEIGHT));
            return PosDataHelper.DRY_INTERVAL.contains(humidity = PosDataHelper.fuzzHumidity(humidity, data.getPos(), HeightGen.this.climateConfig)) ? GroundBlocks.SAND.getSurfaceBlocks(data.getPos()) : GroundBlocks.DIRT.getSurfaceBlocks(data.getPos());
        }

        private double getHeight(BlockPos2D pos, double transitionToBeach) {
            double landHeight = this.heightMapProducer.getMappedHeight(pos);
            return transitionToBeach == 0.0 ? landHeight : MathHelper.lerp(transitionToBeach, landHeight, HeightGen.this.beach.getHeight(pos, 1.0));
        }

        private double getAmp(BlockPos2D pos, double transitionToBeach) {
            double landAmp = this.heightMapProducer.getAmp(pos);
            return transitionToBeach == 0.0 ? landAmp : MathHelper.lerp(transitionToBeach, landAmp, HeightGen.this.beach.getAmp(pos));
        }
    }
}

