/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import com.google.common.collect.Lists;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.PosDataGen;
import weightedgpa.infinibiome.api.generators.PosDataTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.api.posdata.PosDataTable;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.posdata.DataGeneratorBase;
import weightedgpa.infinibiome.internal.generators.posdata.LandmassGen;
import weightedgpa.infinibiome.internal.generators.posdata.PosDataGenHelper;
import weightedgpa.infinibiome.internal.generators.posdata.PosDataProviderBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.pointsprovider.GridRandomPoints;

public final class LakeGen
extends DataGeneratorBase
implements Locatable.HasPointsProvider {
    private static final int GRID_LENGTH = 1024;
    private static final double CHANCE_PER_GRID = (double)0.6f;
    private static final Interval LAKE_DEPTH = new Interval(2.0, 6.0);
    private static final Interval PRIMARY_RADIUS = new Interval(400.0, 800.0);
    private static final int SECONDARY_RADIUS_SCALE = 200;
    private static final double SECONDARY_RADIUS_DEPTH = 0.5;
    private static final double HUMIDITY_BONUS = (double)0.2f;
    private final FloatFunc<BlockPos2D> transitionalPercentFunc;
    private final FloatFunc<BlockPos2D> lakeDepthFunc;
    private final PointsProvider<BlockPos2D> lakeCenters;
    private final PosDataProvider justLandmassGen;

    public LakeGen(DependencyInjector di) {
        super(di, "infinibiome:lake", PosDataTimings.LAKE);
        this.lakeCenters = this.initLakesCenter(this.seed);
        this.transitionalPercentFunc = this.initLakeTransition(this.seed);
        this.lakeDepthFunc = this.initLakeDepth(this.seed);
        this.justLandmassGen = new PosDataProviderBase(Lists.newArrayList((Object[])new PosDataGen[]{di.get(LandmassGen.class)}), 1);
        DebugCommand.registerDebugFunc("lake", "isLake", p -> ((PosDataProvider)this.posDataAfterTiming.get()).get(PosDataKeys.HEIGHT_MODIFIED_BY_LAKE, (BlockPos2D)p));
    }

    private PointsProvider<BlockPos2D> initLakesCenter(Seed seed) {
        seed = seed.newSeed("lakesCenter");
        return new GridRandomPoints<BlockPos2D>(seed, FloatFunc.constFunc(0.6f).randomRound(seed, BlockPos2D.INFO), 1024, BlockPos2D.INFO).filterOutput(this::maySpawn);
    }

    private FloatFunc<BlockPos2D> initLakeTransition(Seed seed) {
        seed = seed.newSeed("lakeTransition");
        final SimplexNoise<BlockPos2D> base = new SimplexNoise<BlockPos2D>(seed, 200.0, BlockPos2D.INFO);
        FloatFunc<BlockPos2D> secondaryRadius = new FloatFunc<BlockPos2D>(){

            @Override
            public double getOutput(BlockPos2D input) {
                return MathHelper.fractal(i -> base.getOutput(input, (double)i), base.getOutputInterval(), 4.0, 0.5, 0.5);
            }

            @Override
            public Interval getOutputInterval() {
                return base.getOutputInterval();
            }
        };
        return GenHelper.initComplexCluster(seed, PRIMARY_RADIUS, secondaryRadius, 0.5, this.lakeCenters);
    }

    private FloatFunc<BlockPos2D> initLakeDepth(Seed seed) {
        seed = seed.newSeed("lakeDepth");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(LAKE_DEPTH);
    }

    @Override
    public void generateData(PosDataTable dataTable) {
        double transitionToLake = this.transitionalPercentFunc.getOutput(dataTable.getPos());
        if ((transitionToLake = MathHelper.ease(transitionToLake, 10.0)) == 0.0) {
            return;
        }
        this.increaseHumidity(dataTable, transitionToLake);
        this.setNewHeight(dataTable, transitionToLake);
        dataTable.set(PosDataKeys.HEIGHT_MODIFIED_BY_LAKE, true);
    }

    private void increaseHumidity(PosDataTable posDataTable, double transitionToLake) {
        if (transitionToLake < 0.5) {
            return;
        }
        transitionToLake = new Interval(0.5, 1.0).mapInterval(transitionToLake, Interval.PERCENT);
        posDataTable.set(PosDataKeys.HUMIDITY, posDataTable.get(PosDataKeys.HUMIDITY).increase((double)0.2f * transitionToLake));
    }

    private void setNewHeight(PosDataTable posDataTable, double transitionToLake) {
        double previousHeight = posDataTable.get(PosDataKeys.MAPPED_HEIGHT);
        double lakeHeight = 63.0 - this.lakeDepthFunc.getOutput(posDataTable.getPos());
        if (lakeHeight > previousHeight) {
            return;
        }
        double newHeight = MathHelper.lerp(transitionToLake, previousHeight, lakeHeight);
        newHeight = PosDataGenHelper.fixHeight(newHeight, previousHeight, posDataTable);
        posDataTable.set(PosDataKeys.MAPPED_HEIGHT, newHeight);
    }

    @Override
    public PointsProvider<BlockPos2D> getAllLocations() {
        return this.lakeCenters;
    }

    private boolean maySpawn(BlockPos2D lakeCenter) {
        return Helper.passesSurroundingTest(lakeCenter, (int)PRIMARY_RADIUS.getMin(), p -> this.justLandmassGen.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)p).isLand(), BlockPos2D.INFO);
    }
}

