/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.PosDataTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileConfig;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileSubConfig;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataTable;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.PerlinNoise;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.floatfunc.util.IntervalMapper;
import weightedgpa.infinibiome.internal.generators.posdata.DataGeneratorBase;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class LandmassGen
extends DataGeneratorBase {
    private static final Interval OCEAN_TRANSITION_LENGTH = new Interval(200.0, 400.0);
    private static final Interval LAND_TRANSITION_LENGTH = new Interval(150.0, 300.0);
    private static final Interval BEACH_LENGTH = new Interval(50.0, 100.0);
    private static final Interval PERSISTENCE = new Interval(0.5, 0.65);
    private static final Interval SCALE_LIMIT = new Interval(10.0, 20.0);
    private final FloatFunc<BlockPos2D> beachLengthFunc;
    private final FloatFunc<BlockPos2D> landToBeachLengthFunc;
    private final FloatFunc<BlockPos2D> oceanToBeachLengthFunc;
    private final FloatFunc<BlockPos2D> scaleLimitFunc;
    private final FloatFunc<BlockPos2D> persistenceFunc;
    private final FloatFunc<BlockPos2D> baseFunc;
    private final Config config;

    public LandmassGen(DependencyInjector di) {
        super(di, "infinibiome:landmass", PosDataTimings.LANDMASS);
        this.config = di.getAll(Config.class).get(0);
        this.beachLengthFunc = this.initBeachLength(this.seed);
        this.landToBeachLengthFunc = this.initLandTransitionLength(this.seed);
        this.oceanToBeachLengthFunc = this.initOceanTransitionLength(this.seed);
        this.scaleLimitFunc = this.initScaleLimitFunc(this.seed);
        this.persistenceFunc = this.initPersistenceFunc(this.seed);
        this.baseFunc = this.initBase(this.seed);
        DebugCommand.registerDebugFunc("landmass", "type", this::getLandMassInfo);
    }

    private FloatFunc<BlockPos2D> initBase(Seed seed) {
        seed = seed.newSeed("base");
        final double scale = this.config.scale;
        final double lacunarity = 0.5;
        final SimplexNoise<BlockPos2D> noise = new SimplexNoise<BlockPos2D>(seed, scale, BlockPos2D.INFO);
        final Interval interval = new Interval(0.0, 1.0 + this.landToBeachLengthFunc.getOutputInterval().getMax() + this.beachLengthFunc.getOutputInterval().getMax() + this.oceanToBeachLengthFunc.getOutputInterval().getMax());
        return new FloatFunc<BlockPos2D>(){

            @Override
            public double getOutput(BlockPos2D input) {
                double octaves = MathHelper.scaleLimitToOctaves(scale, LandmassGen.this.scaleLimitFunc.getOutput(input), lacunarity);
                double result = MathHelper.fractal(i -> noise.getOutput(input, (double)i), noise.getOutputInterval(), octaves, LandmassGen.this.persistenceFunc.getOutput(input), lacunarity);
                result = noise.getOutputInterval().mapInterval(result, interval);
                return result;
            }

            @Override
            public Interval getOutputInterval() {
                return interval;
            }
        };
    }

    private FloatFunc<BlockPos2D> initPersistenceFunc(Seed seed) {
        seed = seed.newSeed("persistence");
        return new PerlinNoise<BlockPos2D>(seed, 2048.0, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE).mapInterval(PERSISTENCE)._setDebuggable("landmass", "persistence", p -> p);
    }

    private FloatFunc<BlockPos2D> initScaleLimitFunc(Seed seed) {
        seed = seed.newSeed("scaleLimit");
        return new PerlinNoise<BlockPos2D>(seed, 2048.0, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE).mapInterval(SCALE_LIMIT)._setDebuggable("landmass", "scaleLimit", p -> p);
    }

    private FloatFunc<BlockPos2D> initOceanTransitionLength(Seed seed) {
        seed = seed.newSeed("OceanTransitionLength");
        return this.initLengthBase(seed, OCEAN_TRANSITION_LENGTH, "oceanTransitionLength");
    }

    private FloatFunc<BlockPos2D> initLandTransitionLength(Seed seed) {
        seed = seed.newSeed("landTransitionLength");
        return this.initLengthBase(seed, LAND_TRANSITION_LENGTH, "landTransitionLength");
    }

    private FloatFunc<BlockPos2D> initBeachLength(Seed seed) {
        seed = seed.newSeed("beachLength");
        return this.initLengthBase(seed, BEACH_LENGTH, "beachLength");
    }

    private FloatFunc<BlockPos2D> initLengthBase(Seed seed, Interval lengthInterval, String debugName) {
        Interval scaledLength = lengthInterval.applyOp(n -> n / this.config.scale);
        FloatFunc<BlockPos2D> result = new PerlinNoise<BlockPos2D>(seed, 2048.0, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE).mapInterval(scaledLength);
        result.mapInterval(lengthInterval)._setDebuggable("landmass", debugName, p -> p);
        return result;
    }

    private void fillTable(PosDataTable dataOutput) {
        dataOutput.set(PosDataKeys.LANDMASS_TYPE, this.getLandMassInfo(dataOutput.getPos()));
    }

    private LandmassInfo getLandMassInfo(BlockPos2D pos) {
        double baseValue = this.baseFunc.getOutput(pos);
        return new IntervalMapper<LandmassInfo>(() -> {
            throw new RuntimeException("should never happen");
        }).addBranch(__ -> {
            double min = this.baseFunc.getOutputInterval().getMin();
            double max = min + this.config.size;
            return new Interval(min, max);
        }, __ -> new LandmassInfo.Land(0.0)).addBranch(n -> {
            if (n.getPrevInterval() == null) {
                return null;
            }
            double landToBeachLength = this.landToBeachLengthFunc.getOutput(pos);
            return n.getPrevInterval().initAhead(landToBeachLength);
        }, i -> {
            double transitionTowardsBeach = i.mapInterval(baseValue, Interval.PERCENT);
            return new LandmassInfo.Land(transitionTowardsBeach);
        }).addBranch(n -> {
            if (n.getPrevInterval() == null) {
                return null;
            }
            double beachLength = this.beachLengthFunc.getOutput(pos);
            return n.getPrevInterval().initAhead(beachLength);
        }, i -> {
            double transitionTowardsLand = 1.0 - i.mapInterval(baseValue, Interval.PERCENT);
            return new LandmassInfo.Beach(transitionTowardsLand);
        }).addBranch(n -> {
            if (n.getPrevInterval() == null) {
                return null;
            }
            double oceanToBeachLength = this.oceanToBeachLengthFunc.getOutput(pos);
            return n.getPrevInterval().initAhead(oceanToBeachLength);
        }, i -> {
            double transitionTowardsBeach = 1.0 - i.mapInterval(baseValue, Interval.PERCENT);
            return new LandmassInfo.Ocean(transitionTowardsBeach);
        }).addBranch(n -> {
            if (n.getPrevInterval() == null) {
                return null;
            }
            double min = n.getPrevInterval().getMax();
            double max = this.baseFunc.getOutputInterval().getMax();
            return new Interval(min, max);
        }, i -> new LandmassInfo.Ocean(0.0)).run(baseValue);
    }

    @Override
    public void generateData(PosDataTable data) {
        this.fillTable(data);
    }

    public static final class Config
    implements FileSubConfig {
        private final double scale;
        private final double size;

        public Config(DependencyInjector di) {
            FileConfig config = di.get(FileConfig.class).subConfig("LAND");
            this.scale = config.getRelativeFloat("landmass_scale", 12000.0, 1000.0, 2.147483647E9, "Doubling/Halving this value will double/halve landmass and oceanmass size.");
            this.size = config.getFloat("landmass_size", 0.45, 0.0, 1.0, "Increasing/Decreasing this value will increase/decrease the land to ocean ratio. This is not a percentage of landmass yet.");
        }
    }
}

