/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.world.biome.Biomes;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.PosDataGen;
import weightedgpa.infinibiome.api.generators.PosDataTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileConfig;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileSubConfig;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.generators.nonworldgen.SpawnPointBlacklist;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.ClimateValue;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.api.posdata.PosDataTable;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.posdata.DataGeneratorBase;
import weightedgpa.infinibiome.internal.generators.posdata.GroundBlocks;
import weightedgpa.infinibiome.internal.generators.posdata.HeightMapProducer;
import weightedgpa.infinibiome.internal.generators.posdata.LandmassGen;
import weightedgpa.infinibiome.internal.generators.posdata.PosDataProviderBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class MushroomIslandGen
extends DataGeneratorBase
implements Locatable.HasPointsProvider,
SpawnPointBlacklist {
    private static final Interval TERRAIN_AMP = new Interval(10.0, 50.0);
    private static final Interval BASE_RADIUS = new Interval(300.0, 500.0);
    private static final int SCALE = 200;
    private static final int OCTAVES = 5;
    private static final double DEPTH = 1.0;
    private final PointsProvider<BlockPos2D> islandCenters;
    private final FloatFunc<BlockPos2D> transitionalPercentFunc;
    private final HeightMapProducer heightMapProducer;
    private final PosDataProvider justLandmassGen;

    public MushroomIslandGen(DependencyInjector di) {
        super(di, "infinibiome:mushroom_island", PosDataTimings.MUSHROOM_ISLAND);
        this.islandCenters = this.initIslandCenters(this.seed);
        this.transitionalPercentFunc = this.initIslandTransition(this.seed);
        this.heightMapProducer = this.initIslandHeight(this.seed);
        this.justLandmassGen = new PosDataProviderBase(Lists.newArrayList((Object[])new PosDataGen[]{di.get(LandmassGen.class)}), 1);
    }

    private PointsProvider<BlockPos2D> initIslandCenters(Seed seed) {
        seed = seed.newSeed("islandCenters");
        return GenHelper.initSeparatedLocations(seed, 512, this.di.get(Config.class).rate).filterOutput(this::maySpawn);
    }

    private boolean maySpawn(BlockPos2D islandCenter) {
        return Helper.passesSurroundingTest(islandCenter, (int)BASE_RADIUS.getMin(), p -> this.justLandmassGen.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)p).isOcean(), BlockPos2D.INFO);
    }

    private FloatFunc<BlockPos2D> initIslandTransition(Seed seed) {
        seed = seed.newSeed("islandTransition");
        final SimplexNoise<BlockPos2D> base = new SimplexNoise<BlockPos2D>(seed, 200.0, BlockPos2D.INFO);
        FloatFunc<BlockPos2D> effect = new FloatFunc<BlockPos2D>(){

            @Override
            public double getOutput(BlockPos2D input) {
                return MathHelper.fractal(i -> base.getOutput(input, (double)i), base.getOutputInterval(), 5.0, 0.5, 0.5);
            }

            @Override
            public Interval getOutputInterval() {
                return base.getOutputInterval();
            }
        };
        return GenHelper.initComplexCluster(seed, BASE_RADIUS, effect, 1.0, this.islandCenters);
    }

    private HeightMapProducer initIslandHeight(Seed seed) {
        seed = seed.newSeed("islandHeight");
        return new HeightMapProducer(seed, FloatFunc.constFunc(63.0), Helper.initUniformNoise(seed.newSeed("amp"), 2048.0).mapInterval(TERRAIN_AMP));
    }

    @Override
    public void generateData(PosDataTable dataTable) {
        double transitionalPercent = this.transitionalPercentFunc.getOutput(dataTable.getPos());
        if (transitionalPercent == 0.0) {
            return;
        }
        transitionalPercent = MathHelper.ease(transitionalPercent, 10.0);
        double height = MathHelper.lerp(transitionalPercent, dataTable.get(PosDataKeys.MAPPED_HEIGHT), this.heightMapProducer.getMappedHeight(dataTable.getPos()));
        dataTable.set(PosDataKeys.MAPPED_HEIGHT, height);
        dataTable.set(PosDataKeys.IS_MUSHROOM_ISLAND, true);
        dataTable.set(PosDataKeys.HUMIDITY, new ClimateValue(0.5, 0.0));
        if (height > 63.0) {
            dataTable.set(PosDataKeys.LANDMASS_TYPE, new LandmassInfo.Land(transitionalPercent));
            dataTable.set(PosDataKeys.OVERRIDE_BIOME, () -> Optional.of(Biomes.field_76789_p));
            dataTable.set(PosDataKeys.GROUND_BLOCKS, () -> GroundBlocks.DIRT.getSurfaceBlocks(dataTable.getPos()));
        } else if (height > 58.0) {
            dataTable.set(PosDataKeys.OVERRIDE_BIOME, () -> Optional.of(Biomes.field_76788_q));
            dataTable.set(PosDataKeys.GROUND_BLOCKS, () -> GroundBlocks.DIRT.getSurfaceBlocks(dataTable.getPos()));
        }
    }

    @Override
    public PointsProvider<BlockPos2D> getAllLocations() {
        return this.islandCenters;
    }

    @Override
    public boolean canSpawnHere(BlockPos2D pos) {
        return ((PosDataProvider)this.posDataAfterTiming.get()).get(PosDataKeys.IS_MUSHROOM_ISLAND, pos) == false;
    }

    public static final class Config
    implements FileSubConfig {
        static final double DEFAULT_VALUE = 0.02;
        private final double rate;

        public Config(DependencyInjector di) {
            this.rate = di.get(FileConfig.class).subConfig("LAND").getRelativeFloat("mushroom_island_rate", 0.02, 0.0, 1.0, "Doubling/Halving this value will double/halve the rate of mushroom islands.");
        }
    }
}

