/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.PosDataGen;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKey;
import weightedgpa.infinibiome.api.posdata.PosDataKeyDefered;
import weightedgpa.infinibiome.api.posdata.PosDataKeyFloat;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.api.posdata.PosDataTable;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.IndexedKeys;
import weightedgpa.infinibiome.internal.misc.IndexedKeysFloat;
import weightedgpa.infinibiome.internal.misc.PosModCache;

public final class PosDataProviderBase
implements PosDataProvider {
    private final List<PosDataGen> dataGens;
    private final PosModCache<BlockPos2D, Table> dataCache;

    public PosDataProviderBase(DependencyInjector di) {
        this(di.getAll(PosDataGen.class), 512);
    }

    public PosDataProviderBase(DependencyInjector di, Timing timing) {
        this(di.getAll(PosDataGen.class), 16);
        this.dataGens.removeIf(p -> p.getTiming().compareTo(timing) >= 0);
    }

    public PosDataProviderBase(List<PosDataGen> dataGens, int cacheSize) {
        this.dataGens = new ArrayList<PosDataGen>(dataGens);
        Helper.strictSort(this.dataGens, Comparator.comparing(PosDataGen::getTiming));
        this.dataCache = new PosModCache<BlockPos2D, Table>(cacheSize, this::posToDataUncached, BlockPos2D.INFO);
    }

    @Override
    public <T> T get(PosDataKey<T> key, BlockPos2D pos) {
        return this.getTable(pos).get(key);
    }

    @Override
    public double get(PosDataKeyFloat key, BlockPos2D pos) {
        return this.getTable(pos).get(key);
    }

    @Override
    public <T> T get(PosDataKeyDefered<T> key, BlockPos2D pos) {
        return this.getTable(pos).get(key);
    }

    private Table getTable(BlockPos2D pos) {
        return this.dataCache.get(pos);
    }

    private Table posToDataUncached(BlockPos2D pos) {
        Table dataOutput = new Table(pos);
        for (PosDataGen dataGen : this.dataGens) {
            this.perDataGen(dataGen, dataOutput);
        }
        return dataOutput;
    }

    private void perDataGen(PosDataGen dataGen, Table dataOutput) {
        try {
            dataGen.generateData(dataOutput);
        }
        catch (Throwable e) {
            throw new RuntimeException(dataGen.toString(), e);
        }
    }

    private static class Table
    implements PosDataTable {
        private final BlockPos2D pos;
        private final IndexedKeys.Table table = INDEXED_KEYS.new IndexedKeys.Table();
        private final IndexedKeys.Table tableDeferred = DEFERRED_KEY_MAP.new IndexedKeys.Table();
        private final IndexedKeysFloat.Table tableFloat = FLOAT_DATA_MAP.new IndexedKeysFloat.Table();

        private Table(BlockPos2D pos) {
            this.pos = pos.toImmutable();
        }

        @Override
        public BlockPos2D getPos() {
            return this.pos;
        }

        @Override
        public <T> T get(PosDataKey<T> key) {
            Object result = this.table.getValue(key.internalKey, this.pos);
            assert (result != null) : "no value set yet";
            return result;
        }

        @Override
        public double get(PosDataKeyFloat key) {
            double result = this.tableFloat.getValue(key.internalKey, this.pos);
            assert (!Double.isNaN(result)) : "no value set yet";
            return result;
        }

        @Override
        public <T> T get(PosDataKeyDefered<T> key) {
            Supplier result = this.tableDeferred.getValue(key.internalKey, this.pos);
            assert (result != null);
            return result.get();
        }

        @Override
        public <T> void set(PosDataKey<T> key, T value) {
            this.table.setValue(key.internalKey, value);
        }

        @Override
        public void set(PosDataKeyFloat key, double item) {
            assert (!Double.isNaN(item));
            this.tableFloat.setValue(key.internalKey, item);
        }

        @Override
        public <T> void set(PosDataKeyDefered<T> key, Supplier<T> valueProducer) {
            this.tableDeferred.setValue(key.internalKey, valueProducer);
        }
    }
}

