/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.posdata;

import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.PosDataTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.api.posdata.PosDataTable;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.IntFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.SeamlessGrid;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.floatfunc.util.IntervalMapper;
import weightedgpa.infinibiome.internal.generators.posdata.DataGeneratorBase;
import weightedgpa.infinibiome.internal.generators.posdata.PosDataGenHelper;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.misc.PregeneratedSeamlessGrid;
import weightedgpa.infinibiome.internal.misc.Unit;
import weightedgpa.infinibiome.internal.pointsprovider.GridRandomPoints;
import weightedgpa.infinibiome.internal.pos.DistortedPos;
import weightedgpa.infinibiome.internal.pos.PosDistorter;

public final class RiverGen
extends DataGeneratorBase
implements Locatable.HasPointsProvider {
    private static final double VORONOI_RATE_PER_GRID = (double)0.4f;
    private static final int VORONOI_GRID_SIZE = 1024;
    private static final int LONG_WINDING_SCALE = 2000;
    private static final int LONG_WINDING_AMP = 500;
    private static final Interval LOCAL_WINDING_AMP = new Interval(30.0, 60.0);
    private static final Interval LOCAL_WINDING_SCALE = new Interval(50.0, 100.0);
    private static final Interval CENTER_TO_SHORE_WIDTH = new Interval(5.0, 20.0);
    private static final Interval SHORE_TO_OUTSIDE_WIDTH = new Interval(40.0, 200.0);
    private static final double MAX_DEPTH_TO_WIDTH_RATIO = 0.25;
    private static final double MAX_HUMIDITY_BONUS = (double)0.1f;
    private static final Interval TRANSITION_EASE = new Interval(2.0, 10.0);
    private static final SeamlessGrid TABLE = PregeneratedSeamlessGrid.TABLE_256_256;
    private final FloatFunc<BlockPos2D> centerToShoreLengthFunc;
    private final FloatFunc<BlockPos2D> shoreToOutsideLengthFunc;
    private final FloatFunc<BlockPos2D> depthPercentFunc;
    private final FloatFunc<BlockPos2D> depthFunc;
    private final FloatFunc<BlockPos2D> localWindingScaleFunc;
    private final FloatFunc<BlockPos2D> easeFunc;
    private final FloatFunc<BlockPos2D> localWindingAmpFunc;
    private final FloatFunc<BlockPos2D> distanceToRiverFunc;

    public RiverGen(DependencyInjector di) {
        super(di, "infinibiome:river", PosDataTimings.RIVER);
        this.centerToShoreLengthFunc = this.initCenterToShoreLength(this.seed);
        this.shoreToOutsideLengthFunc = this.initShoreToOutsideLength(this.seed);
        this.depthPercentFunc = this.initRiverDepthPercent(this.seed);
        this.depthFunc = this.initRiverDepth();
        this.easeFunc = this.initEaseFunc(this.seed);
        this.localWindingScaleFunc = this.initLocalWindingScale(this.seed);
        this.localWindingAmpFunc = this.initLocalWindingAmp(this.seed);
        this.distanceToRiverFunc = this.initDistanceToRiverCenter(this.seed);
        DebugCommand.registerDebugFunc("river", "isRiver", p -> ((PosDataProvider)this.posDataAfterTiming.get()).get(PosDataKeys.HEIGHT_MODIFIED_BY_RIVER, (BlockPos2D)p));
    }

    private FloatFunc<BlockPos2D> initCenterToShoreLength(Seed seed) {
        seed = seed.newSeed("centerToShoreLength");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(CENTER_TO_SHORE_WIDTH)._setDebuggable("river", "halfLength", p -> p);
    }

    private FloatFunc<BlockPos2D> initShoreToOutsideLength(Seed seed) {
        seed = seed.newSeed("shoreToOutsideLength");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(SHORE_TO_OUTSIDE_WIDTH)._setDebuggable("river", "bankLength", p -> p);
    }

    private FloatFunc<BlockPos2D> initRiverDepthPercent(Seed seed) {
        seed = seed.newSeed("riverDepthPercent");
        return Helper.initUniformNoise(seed, 2048.0)._setDebuggable("river", "depthPercent", p -> p);
    }

    private FloatFunc<BlockPos2D> initRiverDepth() {
        return new FloatFunc<BlockPos2D>(){

            @Override
            public double getOutput(BlockPos2D input) {
                double riverWidth = RiverGen.this.centerToShoreLengthFunc.getOutput(input) * 2.0;
                double maxDepth = riverWidth * 0.25;
                double depth = maxDepth * RiverGen.this.depthPercentFunc.getOutput(input);
                if (depth < 1.0) {
                    return 1.0;
                }
                return depth;
            }
        }._setDebuggable("river", "depth", p -> p);
    }

    private FloatFunc<BlockPos2D> initEaseFunc(Seed seed) {
        seed = seed.newSeed("ease");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(TRANSITION_EASE)._setDebuggable("river", "ease", p -> p);
    }

    private FloatFunc<BlockPos2D> initLocalWindingScale(Seed seed) {
        seed = seed.newSeed("windingScale");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(LOCAL_WINDING_SCALE)._setDebuggable("river", "scale", (t, p) -> PregeneratedSeamlessGrid.TABLE_256_256._debugValue((BlockPos2D)p, t::getOutput));
    }

    private FloatFunc<BlockPos2D> initLocalWindingAmp(Seed seed) {
        seed = seed.newSeed("windingAmp");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(LOCAL_WINDING_AMP)._setDebuggable("river", "amp", p -> p);
    }

    private FloatFunc<BlockPos2D> initLocalWinding(Seed seed) {
        seed = seed.newSeed("localDistortion");
        SimplexNoise<BlockPos2D> noise = new SimplexNoise<BlockPos2D>(seed, 1.0, BlockPos2D.INFO);
        return input -> {
            double result = TABLE.getValue(input, gridPos -> MathHelper.fractal(i -> {
                double localScale = this.localWindingScaleFunc.getOutput((BlockPos2D)gridPos);
                return noise.getOutput((BlockPos2D)input, i * localScale);
            }, noise.getOutputInterval(), 4.0, 0.5, 0.5), BlockPos2D.INFO);
            result = noise.getOutputInterval().mapInterval(result, new Interval(-1.0, 1.0));
            return result *= this.localWindingAmpFunc.getOutput((BlockPos2D)input);
        };
    }

    private FloatFunc<BlockPos2D> initLongWinding(Seed seed) {
        seed = seed.newSeed("longDistortion");
        SimplexNoise<BlockPos2D> base = new SimplexNoise<BlockPos2D>(seed, 2000.0, BlockPos2D.INFO);
        return input -> {
            double result = MathHelper.fractal(i -> base.getOutput((BlockPos2D)input, (double)i), base.getOutputInterval(), 4.0, 0.5, 0.5);
            result = base.getOutputInterval().mapInterval(result, new Interval(-500.0, 500.0));
            return result;
        };
    }

    private FloatFunc<BlockPos2D> initDistanceToRiverCenter(Seed seed) {
        seed = seed.newSeed("distanceToRiver");
        PosDistorter<BlockPos2D> distorter = new PosDistorter<BlockPos2D>(seed.newSeed("localWindingDistorter"), s -> FloatFunc.sum(this.initLocalWinding((Seed)s), this.initLongWinding((Seed)s)), BlockPos2D.INFO);
        PointsProvider<DistortedPos> voronoiPoints = this.initVoronoiPoints(seed);
        return input -> {
            DistortedPos distortedInput = distorter.distortPos((BlockPos2D)input);
            return voronoiPoints.getDistanceToVoronoiBorder(distortedInput);
        };
    }

    private PointsProvider<DistortedPos> initVoronoiPoints(Seed seed) {
        seed = seed.newSeed("voronoiPoints");
        IntFunc<DistortedPos> voronoiPointsGridCount = FloatFunc.constFunc(0.4f).randomRound(seed, DistortedPos.INFO.floor());
        return new GridRandomPoints<DistortedPos>(seed, voronoiPointsGridCount, 1024, DistortedPos.INFO);
    }

    private void fillData(PosDataTable dataTable) {
        double distanceToRiver = this.distanceToRiverFunc.getOutput(dataTable.getPos());
        new IntervalMapper<Unit>(() -> Unit.INSTANCE).addBranch(__ -> {
            double centerToShoreLength = this.centerToShoreLengthFunc.getOutput(dataTable.getPos());
            return new Interval(0.0, centerToShoreLength);
        }, i -> {
            double transitionToBank = i.mapInterval(distanceToRiver, Interval.PERCENT);
            this.centerToShore(dataTable, transitionToBank);
            return Unit.INSTANCE;
        }).addBranch(n -> {
            if (n.getPrevInterval() == null) {
                return null;
            }
            double shoreToOutsideLength = this.shoreToOutsideLengthFunc.getOutput(dataTable.getPos());
            return n.getPrevInterval().initAhead(shoreToOutsideLength);
        }, i -> {
            double transitionToOutside = i.mapInterval(distanceToRiver, Interval.PERCENT);
            this.shoreToOutside(dataTable, transitionToOutside);
            return Unit.INSTANCE;
        }).run(distanceToRiver);
    }

    private void centerToShore(PosDataTable posDataTable, double centerToShorePercent) {
        double outsideHeight;
        double shoreHeight;
        double centerHeight;
        double newHeight = MathHelper.lerp(centerToShorePercent = MathHelper.ease(centerToShorePercent, this.easeFunc.getOutput(posDataTable.getPos())), centerHeight = (shoreHeight = 63.0) - this.depthFunc.getOutput(posDataTable.getPos()), shoreHeight);
        if (newHeight > (outsideHeight = posDataTable.get(PosDataKeys.MAPPED_HEIGHT))) {
            return;
        }
        posDataTable.set(PosDataKeys.MAPPED_HEIGHT, newHeight);
        this.markAsRiver(posDataTable);
        this.increaseHumidity(posDataTable, 0.0);
    }

    private void shoreToOutside(PosDataTable posDataTable, double shoreToOutsidePercent) {
        double previousHeight;
        double shoreHeight;
        double newHeight = MathHelper.lerp(shoreToOutsidePercent = MathHelper.ease(shoreToOutsidePercent, this.easeFunc.getOutput(posDataTable.getPos())), shoreHeight = 63.0, previousHeight = posDataTable.get(PosDataKeys.MAPPED_HEIGHT));
        if (newHeight > previousHeight) {
            return;
        }
        newHeight = PosDataGenHelper.fixHeight(newHeight, previousHeight, posDataTable);
        posDataTable.set(PosDataKeys.MAPPED_HEIGHT, newHeight);
        this.increaseHumidity(posDataTable, shoreToOutsidePercent);
    }

    private void markAsRiver(PosDataTable dataTable) {
        if (dataTable.get(PosDataKeys.LANDMASS_TYPE).isOcean()) {
            return;
        }
        dataTable.set(PosDataKeys.HEIGHT_MODIFIED_BY_RIVER, true);
    }

    private void increaseHumidity(PosDataTable posDataTable, double shoreToOutsidePercent) {
        if (posDataTable.get(PosDataKeys.LANDMASS_TYPE).isOcean()) {
            return;
        }
        double humidityIncrease = 0.1f;
        humidityIncrease *= this.depthPercentFunc.getOutput(posDataTable.getPos());
        posDataTable.set(PosDataKeys.HUMIDITY, posDataTable.get(PosDataKeys.HUMIDITY).increase(humidityIncrease *= 1.0 - shoreToOutsidePercent));
    }

    @Override
    public void generateData(PosDataTable dataTable) {
        this.fillData(dataTable);
    }

    @Override
    public PointsProvider<BlockPos2D> getAllLocations() {
        return new PredicateSearcher<BlockPos2D>(16, p -> ((PosDataProvider)this.posDataAfterTiming.get()).get(PosDataKeys.HEIGHT_MODIFIED_BY_RIVER, (BlockPos2D)p) != false && PosDataHelper.isUnderWaterAt(p, (PosDataProvider)this.posDataAfterTiming.get()), BlockPos2D.INFO);
    }
}

