/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.utils;

import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.pointsprovider.EmptyPointsProvider;
import weightedgpa.infinibiome.internal.pointsprovider.GridLowestPoint;

public final class GenHelper {
    public static final Interval WARMISH = Interval.union(PosDataHelper.HOT_INTERVAL, PosDataHelper.WARM_INTERVAL);
    public static final Interval COLDISH = Interval.union(PosDataHelper.COLD_INTERVAL, PosDataHelper.FREEZE_INTERVAL);
    public static final Interval NOT_FREEZING = Interval.union(PosDataHelper.HOT_INTERVAL, PosDataHelper.WARM_INTERVAL, PosDataHelper.COLD_INTERVAL);
    public static final Interval UPPER_HOT_INTERVAL = new Interval(PosDataHelper.HOT_INTERVAL.getMax(), PosDataHelper.HOT_INTERVAL.getMidPoint());
    public static final Interval LOWER_HOT_INTERVAL = new Interval(PosDataHelper.HOT_INTERVAL.getMidPoint(), PosDataHelper.HOT_INTERVAL.getMin());
    public static final Interval UPPER_FREEZE_INTERVAL = new Interval(PosDataHelper.FREEZE_INTERVAL.getMax(), PosDataHelper.FREEZE_INTERVAL.getMidPoint());
    public static final Interval LOWER_FREEZE_INTERVAL = new Interval(PosDataHelper.FREEZE_INTERVAL.getMidPoint(), PosDataHelper.FREEZE_INTERVAL.getMin());
    public static final Interval WETISH = Interval.union(PosDataHelper.WET_INTERVAL, PosDataHelper.SEMI_WET_INTERVAL);
    public static final Interval DRYISH = Interval.union(PosDataHelper.DRY_INTERVAL, PosDataHelper.SEMI_DRY_INTERVAL);
    public static final Interval NOT_DESERT = Interval.union(PosDataHelper.WET_INTERVAL, PosDataHelper.SEMI_WET_INTERVAL, PosDataHelper.SEMI_DRY_INTERVAL);
    public static final Interval NON_FORESTED_TREE_INTERVAL = new Interval(0.0, 0.25);
    public static final Interval FORESTED_TREE_INTERVAL = new Interval(0.25, Double.POSITIVE_INFINITY);

    private GenHelper() {
    }

    public static PointsProvider<BlockPos2D> getCommonPredicateSearcher(int gridSize, boolean isUnderwater, ConditionList conditions, PosDataProvider posData) {
        return new PredicateSearcher<BlockPos2D>(gridSize, p -> {
            if (!conditions.canBeHere((BlockPos2D)p)) {
                return false;
            }
            if (isUnderwater) {
                return PosDataHelper.isUnderwaterPortionOfLakeOrRiver(p, posData) || posData.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)p).isOcean();
            }
            return posData.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)p).isLand();
        }, BlockPos2D.INFO);
    }

    public static FloatFunc<BlockPos2D> initComplexCluster(Seed seed, Interval primaryRadiusSize, FloatFunc<BlockPos2D> secondaryRadius, double secondaryRadiusDepth, PointsProvider<BlockPos2D> centers) {
        Validate.isTrue(Interval.PERCENT.contains(secondaryRadiusDepth));
        seed = seed.newSeed("complexCluster");
        secondaryRadius = secondaryRadius.mapInterval(new Interval(1.0 - secondaryRadiusDepth, 1.0));
        final FloatFunc<BlockPos2D> baseRadiusFunc = new RandomGen(seed.newSeed("baseRadius")).asPercentFloatFunc(BlockPos2D.INFO).mapInterval(primaryRadiusSize);
        final Interval outputInterval = new Interval(0.0, primaryRadiusSize.getMax());
        FloatFunc<BlockPos2D> effectFunc_ = secondaryRadius;
        return input -> {
            final double effectFuncOutput = effectFunc_.getOutput((BlockPos2D)input);
            FloatFunc<BlockPos2D> clusterCenterToRadius = new FloatFunc<BlockPos2D>(){

                @Override
                public double getOutput(BlockPos2D clusterCenter) {
                    double result = baseRadiusFunc.getOutput(clusterCenter);
                    return result *= effectFuncOutput;
                }

                @Override
                public Interval getOutputInterval() {
                    return outputInterval;
                }
            };
            return MathHelper.gradientTowardsPoint(input, clusterCenterToRadius, centers);
        };
    }

    public static PointsProvider<BlockPos2D> initSeparatedLocations(Seed seed, int gridSize, double rate) {
        Validate.isTrue(gridSize > 0);
        Validate.isTrue(Interval.PERCENT.contains(rate));
        seed = seed.newSeed("blockPosLocations");
        if (rate == 0.0) {
            return new EmptyPointsProvider<BlockPos2D>(BlockPos2D.INFO);
        }
        return new GridLowestPoint<BlockPos2D>(gridSize, BlockPos2D.INFO).filterOutput(FloatFunc.constFunc(rate).randomBool(BlockPos2D.INFO, seed));
    }
}

