/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.utils;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.function.Predicate;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.pointsprovider.GriddedPointsProvider;
import weightedgpa.infinibiome.internal.pos.Grid;

public final class PredicateSearcher<T>
extends GriddedPointsProvider<T> {
    private final Predicate<T> predicate;
    private final int gridLengthLog2;
    private final PosInfo<T> posInfo;

    public PredicateSearcher(int gridSize, Predicate<T> predicate, PosInfo<T> posInfo) {
        this.predicate = predicate;
        this.gridLengthLog2 = Log2helper.asLog2(gridSize);
        this.posInfo = posInfo;
    }

    @Override
    public int getgridLengthLog2() {
        return this.gridLengthLog2;
    }

    @Override
    public PosInfo<T> getPosInfo() {
        return this.posInfo;
    }

    @Override
    public Iterable<T> getOutputFromGrid(Grid<T> grid) {
        T pos = grid.getLowest();
        if (this.predicate.test(pos)) {
            return Lists.newArrayList((Object[])new Object[]{pos});
        }
        return Collections.emptyList();
    }
}

