/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public final class SortedRandomizedList<T> {
    private final List<ItemGroup> itemGroups = new ArrayList<ItemGroup>();
    private final Comparator<T> comparator;

    public SortedRandomizedList(Iterable<T> items, Comparator<T> comparator) {
        this.comparator = comparator;
        this.initGroups(items);
    }

    private void initGroups(Iterable<T> items) {
        for (T item : items) {
            this.addItemToGroups(item);
        }
        this.itemGroups.sort(ItemGroup::compareTo);
    }

    private void addItemToGroups(T item) {
        for (ItemGroup group : this.itemGroups) {
            if (!group.addIfPartOfGroup(item)) continue;
            return;
        }
        this.itemGroups.add(new ItemGroup(item));
    }

    public void forEachItem(Predicate<T> itemConsumer) {
        for (ItemGroup group : this.itemGroups) {
            group.perItem(itemConsumer);
        }
    }

    private class ItemGroup
    implements Comparable<ItemGroup> {
        private final List<T> items = new ArrayList();

        private ItemGroup(T item) {
            this.items.add(item);
        }

        boolean addIfPartOfGroup(T item) {
            if (SortedRandomizedList.this.comparator.compare(item, this.items.get(0)) == 0) {
                this.items.add(item);
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(ItemGroup other) {
            return SortedRandomizedList.this.comparator.compare(this.items.get(0), other.items.get(0));
        }

        void perItem(Predicate<T> itemConsumer) {
            Object item;
            boolean continueFlag;
            ArrayList randomizedGroup = new ArrayList(this.items);
            Collections.shuffle(randomizedGroup);
            Iterator iterator = randomizedGroup.iterator();
            while (iterator.hasNext() && (continueFlag = itemConsumer.test(item = iterator.next()))) {
            }
        }
    }
}

