/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.utils.condition;

import net.minecraft.util.math.ChunkPos;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.Interpolation;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public abstract class Condition {
    public abstract double getProbability(BlockPos2D var1);

    public boolean isSlow() {
        return false;
    }

    public boolean isStrict() {
        return false;
    }

    public double getProbability(ChunkPos pos) {
        return this.getProbability(MCHelper.lowestPos(pos));
    }

    public boolean likelyConflicts(Condition other) {
        return this.getClass() == other.getClass();
    }

    public Condition invert() {
        return new WrapperCondition(this){

            @Override
            public double getProbability(BlockPos2D pos) {
                return 1.0 - Condition.this.getProbability(pos);
            }

            @Override
            public double getProbability(ChunkPos pos) {
                return 1.0 - Condition.this.getProbability(pos);
            }

            public String toString() {
                return "Invert{" + this.getInner() + "}";
            }
        };
    }

    public Condition noConflict() {
        return new WrapperCondition(this){

            @Override
            public boolean likelyConflicts(Condition other) {
                return false;
            }

            public String toString() {
                return "NoConflict{" + this.getInner() + "}";
            }
        };
    }

    public Condition activeOutside(Condition chooser) {
        return ConditionHelper.switchBetweenConditions(chooser, new Condition(){

            @Override
            public double getProbability(BlockPos2D pos) {
                return 1.0;
            }

            public String toString() {
                return "Always1{}";
            }
        }, this);
    }

    public static abstract class BoolStrict
    extends Condition {
        public abstract boolean passes(BlockPos2D var1);

        @Override
        public final boolean isStrict() {
            return true;
        }

        @Override
        public double getProbability(BlockPos2D pos) {
            return this.passes(pos) ? 1.0 : 0.0;
        }
    }

    public static abstract class BoolInterpolated
    extends Condition {
        private final Interpolation<BlockPos2D> interpolation = new Interpolation<BlockPos2D>(p -> this.passes((BlockPos2D)p) ? 1.0 : 0.0, 16, 4, BlockPos2D.INFO);

        public abstract boolean passes(BlockPos2D var1);

        @Override
        public final boolean isStrict() {
            return false;
        }

        @Override
        public double getProbability(BlockPos2D pos) {
            return this.interpolation.getOutput(pos);
        }

        @Override
        public double getProbability(ChunkPos pos) {
            return this.passes(MCHelper.lowestPos(pos)) ? 1.0 : 0.0;
        }
    }

    public static abstract class WrapperCondition
    extends Condition {
        private final Condition inner;

        protected WrapperCondition(Condition inner) {
            this.inner = inner;
        }

        @Override
        public double getProbability(BlockPos2D pos) {
            return this.inner.getProbability(pos);
        }

        @Override
        public double getProbability(ChunkPos pos) {
            return this.inner.getProbability(pos);
        }

        @Override
        public boolean isSlow() {
            return this.inner.isSlow();
        }

        @Override
        public boolean isStrict() {
            return this.inner.isStrict();
        }

        @Override
        public boolean likelyConflicts(Condition other) {
            if (other instanceof WrapperCondition) {
                return this.inner.likelyConflicts(((WrapperCondition)other).getInner());
            }
            return this.inner.likelyConflicts(other);
        }

        @Override
        public Condition invert() {
            return this.inner.invert();
        }

        @Override
        public Condition noConflict() {
            return this.inner.noConflict();
        }

        @Override
        public Condition activeOutside(Condition chooser) {
            return this.inner.activeOutside(chooser);
        }

        Condition getInner() {
            return this.inner;
        }
    }
}

