/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.utils.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.math.ChunkPos;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.MultiDep;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.IntervalMapperWrapper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeGens;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.pointsprovider.EmptyPointsProvider;
import weightedgpa.infinibiome.internal.pointsprovider.GridLowestPoint;
import weightedgpa.infinibiome.internal.pointsprovider.GridRandomPoints;

public final class ConditionHelper {
    private ConditionHelper() {
    }

    public static Condition chancePerChunk(final double rate) {
        return new Condition(){

            @Override
            public double getProbability(BlockPos2D pos) {
                return rate;
            }

            public String toString() {
                return "ChancePerChunk{chance=" + rate + "}";
            }
        };
    }

    public static Condition onlyInRegion(Seed seed, double rate) {
        return ConditionHelper.onlyInRegion(seed, rate, 0.5);
    }

    public static Condition onlyInRegion(Seed seed, double rate, double fade) {
        seed = seed.newSeed("spawnRegion");
        Validate.isTrue(rate >= 0.0);
        Validate.isTrue(Interval.PERCENT.contains(fade));
        if (rate == 0.0) {
            return new Condition.BoolInterpolated(){

                @Override
                public boolean passes(BlockPos2D pos) {
                    return false;
                }

                public String toString() {
                    return "AlwaysNoRegion{}";
                }
            };
        }
        FloatFunc<BlockPos2D> radiusFunc = ConditionHelper.initRegionRadius(seed);
        PointsProvider<BlockPos2D> centers = ConditionHelper.initRegionCenters(seed, rate);
        final IntervalMapperWrapper<BlockPos2D> noise = new IntervalMapperWrapper<BlockPos2D>(input -> MathHelper.gradientTowardsPoint(input, radiusFunc.getOutput((BlockPos2D)input), centers)).addBranch(new Interval(0.0, fade), 0.0, 1.0).addBranch(new Interval(fade, 1.0), 1.0, 1.0);
        return new Condition(){

            @Override
            public double getProbability(BlockPos2D pos) {
                return noise.getOutput(pos);
            }

            public String toString() {
                return "OnlyInRegion{}";
            }
        };
    }

    private static FloatFunc<BlockPos2D> initRegionRadius(Seed seed) {
        seed = seed.newSeed("radius");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(new Interval(100.0, 500.0));
    }

    private static PointsProvider<BlockPos2D> initRegionCenters(Seed seed, double rate) {
        seed = seed.newSeed("regionCenter");
        return new GridRandomPoints<BlockPos2D>(seed, FloatFunc.constFunc(rate).randomRound(seed, BlockPos2D.INFO), 512, BlockPos2D.INFO);
    }

    public static Condition onlyInTemperature(final DependencyInjector di, final Interval interval) {
        return new Condition(){
            final FloatFunc<BlockPos2D> tempFunc;
            {
                this.tempFunc = ConditionHelper.initClimateNoise(PosDataHelper.initTemperatureNoise2D(di), 0.05f, interval);
            }

            @Override
            public double getProbability(BlockPos2D pos) {
                return this.tempFunc.getOutput(pos);
            }

            public String toString() {
                return "OnlyInTemperature{}";
            }
        };
    }

    public static Condition onlyInHumidity(final DependencyInjector di, final Interval interval) {
        return new Condition(){
            final FloatFunc<BlockPos2D> humidityFunc;
            {
                this.humidityFunc = ConditionHelper.initClimateNoise(PosDataHelper.initHumidityNoise2D(di), 0.05f, interval);
            }

            @Override
            public double getProbability(BlockPos2D pos) {
                return this.humidityFunc.getOutput(pos);
            }

            public String toString() {
                return "OnlyInHumidity{}";
            }
        };
    }

    private static FloatFunc<BlockPos2D> initClimateNoise(FloatFunc<BlockPos2D> base, double dist, Interval interval) {
        Validate.isTrue(Interval.PERCENT.containsAll(interval));
        Validate.isTrue(dist > 0.0);
        if (interval.getSize() < dist * 2.0) {
            dist = interval.getSize() * 0.2;
        }
        IntervalMapperWrapper<BlockPos2D> intervalMapper = new IntervalMapperWrapper<BlockPos2D>(base);
        Interval baseIntervalShrunk = ConditionHelper.shrinkInterval(interval, dist);
        intervalMapper.addBranch(baseIntervalShrunk.initBehind(dist), 0.0, 1.0);
        intervalMapper.addBranch(baseIntervalShrunk, 1.0, 1.0);
        intervalMapper.addBranch(baseIntervalShrunk.initAhead(dist), 1.0, 0.0);
        return intervalMapper;
    }

    private static Interval shrinkInterval(Interval interval, double dist) {
        double min = interval.getMin() == 0.0 ? 0.0 : interval.getMin() + dist;
        double max = interval.getMax() == 1.0 ? 1.0 : interval.getMax() - dist;
        return new Interval(min, max);
    }

    public static Condition onlyInAmp(final DependencyInjector di, final Interval validAmp) {
        DebugCommand.registerDebugFunc("posData", "amp", p -> di.get(PosDataProvider.class).get(PosDataKeys.AMP, (BlockPos2D)p));
        return new Condition.BoolInterpolated(){
            final PosDataProvider posData;
            {
                this.posData = di.get(PosDataProvider.class);
            }

            @Override
            public boolean passes(BlockPos2D pos) {
                return validAmp.contains(this.posData.get(PosDataKeys.AMP, pos));
            }

            public String toString() {
                return "OnlyInAmp{}";
            }
        };
    }

    public static Condition onlyInHeight(final DependencyInjector di, final int radius, final Interval validHeight) {
        return new Condition.BoolInterpolated(){
            final PosDataProvider posData;
            {
                this.posData = di.get(PosDataProvider.class);
            }

            @Override
            public boolean passes(BlockPos2D pos) {
                return Helper.passesSurroundingTest(pos, radius, p -> validHeight.contains(this.posData.get(PosDataKeys.MAPPED_HEIGHT, (BlockPos2D)p)), BlockPos2D.INFO);
            }

            @Override
            public boolean isSlow() {
                return radius != 0;
            }

            public String toString() {
                return "OnlyInHeight{}";
            }
        };
    }

    public static Condition onlyInHeight(DependencyInjector di, Interval validHeight) {
        return ConditionHelper.onlyInHeight(di, 0, validHeight);
    }

    public static Condition onlyInLandMass(DependencyInjector di, Predicate<LandmassInfo> predicate) {
        return ConditionHelper.onlyInLandMass(di, 0, predicate);
    }

    public static Condition onlyInLandMass(final DependencyInjector di, final int radius, final Predicate<LandmassInfo> predicate) {
        return new Condition.BoolStrict(){
            final PosDataProvider posData;
            {
                this.posData = di.get(PosDataProvider.class);
            }

            @Override
            public boolean passes(BlockPos2D pos) {
                return Helper.passesSurroundingTest(pos, radius, p -> predicate.test(this.posData.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)p)), BlockPos2D.INFO);
            }

            @Override
            public boolean isSlow() {
                return radius != 0;
            }

            public String toString() {
                return "OnlyInLandmass{}";
            }
        };
    }

    public static Condition onlyInTreeDensity(final DependencyInjector di, final Interval allowedTreeDensity) {
        return new Condition.BoolInterpolated(){
            private final TreeGens treeGen;
            private final PosDataProvider posData;
            {
                this.treeGen = di.get(TreeGens.class);
                this.posData = di.get(PosDataProvider.class);
            }

            @Override
            public boolean passes(BlockPos2D pos) {
                double humidity = PosDataHelper.getHumidity(pos, this.posData);
                double treeDensity = PosDataHelper.DRY_INTERVAL.contains(humidity) || this.posData.get(PosDataKeys.LANDMASS_TYPE, pos).isOcean() ? 0.0 : this.treeGen.getApproxDensity(new InterChunkPos(pos));
                return allowedTreeDensity.contains(treeDensity);
            }

            @Override
            public boolean isSlow() {
                return true;
            }

            public String toString() {
                return "OnlyInTreeDensity{}";
            }
        };
    }

    public static Condition onlyInSlope(DependencyInjector di, int radius, Interval validSlope) {
        PosDataProvider posData = di.get(PosDataProvider.class);
        DebugCommand.registerDebugFunc("slope", "10", p -> String.valueOf(PosDataHelper.getAverageSlope(p, 10, posData)));
        DebugCommand.registerDebugFunc("slope", "20", p -> String.valueOf(PosDataHelper.getAverageSlope(p, 20, posData)));
        return ConditionHelper.onlyInSlope(p -> posData.get(PosDataKeys.MAPPED_HEIGHT, (BlockPos2D)p), p -> !PosDataHelper.isUnderwaterPortionOfLakeOrRiver(p, posData), radius, validSlope);
    }

    public static Condition onlyInSlope(final Function<BlockPos2D, Double> heightFunc, final Predicate<BlockPos2D> shouldCount, final int radius, final Interval validSlope) {
        return new Condition.BoolInterpolated(){

            @Override
            public boolean passes(BlockPos2D pos) {
                return validSlope.contains(PosDataHelper.getAverageSlope(pos, radius, heightFunc, shouldCount));
            }

            @Override
            public boolean isSlow() {
                return true;
            }

            public String toString() {
                return "OnlyInSlope{}";
            }
        };
    }

    public static Condition onlyInMushroomIsland(final DependencyInjector di) {
        return new Condition.BoolStrict(){
            final PosDataProvider posData;
            {
                this.posData = di.get(PosDataProvider.class);
            }

            @Override
            public boolean passes(BlockPos2D pos) {
                return this.posData.get(PosDataKeys.IS_MUSHROOM_ISLAND, pos);
            }

            public String toString() {
                return "OnlyInMushroomIsland{}";
            }
        };
    }

    @SafeVarargs
    public static <T extends MultiDep> Condition onlyIfNotNear(DependencyInjector di, final int radius, final BiPredicate<T, InterChunkPos> spawnsIn, final Class<? extends T> ... generatorBase) {
        final ArrayList<? extends T> genBases = new ArrayList<T>();
        for (Class<? extends T> mobClass : generatorBase) {
            genBases.addAll(di.getAll(mobClass));
        }
        return new Condition.BoolInterpolated(){

            @Override
            public boolean passes(BlockPos2D pos) {
                InterChunkPos interChunkPos = new InterChunkPos(pos);
                for (MultiDep base : genBases) {
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (!spawnsIn.test(base, interChunkPos.offset(x, z))) continue;
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean isSlow() {
                return true;
            }

            public String toString() {
                return "OnlyNotNear{list=" + Arrays.asList(generatorBase) + "}";
            }
        };
    }

    public static Condition onlyInPoints(final PointsProvider<InterChunkPos> pointsProvider) {
        return new Condition.BoolStrict(){

            @Override
            public boolean passes(BlockPos2D pos) {
                InterChunkPos interChunkPos = new InterChunkPos(pos);
                return pointsProvider.hasPoint(interChunkPos);
            }

            public String toString() {
                return "OnlyInPoints{}";
            }
        };
    }

    public static PointsProvider<ChunkPos> initSeparatedChunkLocations(Seed seed, int gridSize, double rate) {
        Validate.isTrue(gridSize > 0);
        Validate.isTrue(Interval.PERCENT.contains(rate));
        seed = seed.newSeed("chunkPosLocations");
        if (rate == 0.0) {
            return new EmptyPointsProvider<ChunkPos>(MCHelper.CHUNK_POS_INFO);
        }
        return new GridLowestPoint<ChunkPos>(gridSize, MCHelper.CHUNK_POS_INFO).filterOutput(FloatFunc.constFunc(rate).randomBool(MCHelper.CHUNK_POS_INFO, seed));
    }

    public static Condition switchBetweenConditions(final Condition chooser, final Condition runWhen1, final Condition runWhen0) {
        return new Condition(){

            @Override
            public double getProbability(BlockPos2D pos) {
                double chooserOutput = chooser.getProbability(pos);
                if (chooserOutput == 0.0) {
                    return runWhen0.getProbability(pos);
                }
                if (chooserOutput == 1.0) {
                    return runWhen1.getProbability(pos);
                }
                return MathHelper.lerp(chooserOutput, runWhen0.getProbability(pos), runWhen1.getProbability(pos));
            }

            @Override
            public boolean isSlow() {
                return chooser.isSlow() || runWhen1.isSlow() || runWhen0.isSlow();
            }

            @Override
            public boolean likelyConflicts(Condition other) {
                return false;
            }

            public String toString() {
                return "Switch{chooser=" + chooser + ", runWhen1=" + runWhen1 + ", runWhen0=" + runWhen0 + "}";
            }
        };
    }

    public static Condition onlyWhereInfibiomeGenAllowed(DependencyInjector di) {
        final PosDataProvider posData = di.get(PosDataProvider.class);
        return new Condition.BoolStrict(){

            @Override
            public boolean passes(BlockPos2D pos) {
                return posData.get(PosDataKeys.AllOW_INFINIBIOME_GEN, pos);
            }

            public String toString() {
                return "OnlyWhereIBGenAllowed{}";
            }
        };
    }
}

