/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.utils.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.ChunkPos;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;

public final class ConditionList {
    private final List<Condition> all = new ArrayList<Condition>();

    public ConditionList(List<Condition> conditions) {
        conditions.forEach(this::addCondition);
        this.checkOverlap();
    }

    public ConditionList(Condition ... conditions) {
        this(Arrays.asList(conditions));
    }

    private void addCondition(Condition c) {
        if (c.isSlow()) {
            this.all.add(c);
        } else {
            this.all.add(0, c);
        }
    }

    private void checkOverlap() {
        for (int i = 0; i < this.all.size(); ++i) {
            for (int j = 0; j < this.all.size() && i != j; ++j) {
                Condition c2;
                Condition c1 = this.all.get(i);
                if (!c1.likelyConflicts(c2 = this.all.get(j)) && !c2.likelyConflicts(c1)) continue;
                throw new RuntimeException(c1 + " " + c2 + " conflicts");
            }
        }
    }

    public ConditionList add(Condition ... conditions) {
        return this.add(Arrays.asList(conditions));
    }

    public ConditionList add(Collection<Condition> conditions) {
        ArrayList<Condition> result = new ArrayList<Condition>();
        result.addAll(this.all);
        result.addAll(conditions);
        return new ConditionList(result);
    }

    public double getAllProbability(InterChunkPos pos, StrictOption strictOption) {
        return this.getAllProbability(pos.getLowestChunkPos(), strictOption);
    }

    public double getAllProbability(ChunkPos pos, StrictOption strictOption) {
        double probability = 1.0;
        for (Condition c : this.all) {
            if ((probability *= strictOption.getProbability(c, pos)) != 0.0) continue;
            return 0.0;
        }
        return probability;
    }

    public double getAllProbability(BlockPos2D pos, StrictOption strictOption) {
        double probability = 1.0;
        for (Condition c : this.all) {
            if ((probability *= strictOption.getProbability(c, pos)) != 0.0) continue;
            return 0.0;
        }
        return probability;
    }

    public String _debug(BlockPos2D pos) {
        String result = "";
        double probability = 1.0;
        for (Condition c : this.all) {
            result = result + "{\n";
            double multiplier = c.getProbability(pos);
            probability *= multiplier;
            result = result + c.toString() + "\n";
            result = result + "multiplier: " + multiplier + "\n";
            result = result + "isSlow: " + c.isSlow() + "\n";
            result = result + "}\n";
        }
        result = result + probability;
        return result;
    }

    public boolean canBeHere(BlockPos2D p) {
        return this.getAllProbability(p, StrictOption.USE_LIKE_NON_STRICT) > 0.0;
    }

    public boolean canBeHere(InterChunkPos p) {
        return this.getAllProbability(p, StrictOption.USE_LIKE_NON_STRICT) > 0.0;
    }

    public static enum StrictOption {
        USE_LIKE_NON_STRICT{

            @Override
            double getProbability(Condition c, BlockPos2D pos) {
                return c.getProbability(pos);
            }

            @Override
            double getProbability(Condition c, ChunkPos pos) {
                return c.getProbability(pos);
            }
        }
        ,
        FOUR_CORNER_CHECK{

            @Override
            double getProbability(Condition c, BlockPos2D pos) {
                if (!c.isStrict()) {
                    return c.getProbability(pos);
                }
                double result = 0.0;
                for (int x : new int[]{0, 16}) {
                    for (int z : new int[]{0, 16}) {
                        double multiplier = c.getProbability(pos.offset(x, z));
                        if (multiplier == 0.0) {
                            return 0.0;
                        }
                        result += multiplier;
                    }
                }
                return result / 4.0;
            }

            @Override
            double getProbability(Condition c, ChunkPos pos) {
                if (!c.isStrict()) {
                    return c.getProbability(pos);
                }
                double result = 0.0;
                for (int x : new int[]{0, 1}) {
                    for (int z : new int[]{0, 1}) {
                        double multiplier = c.getProbability(new ChunkPos(pos.field_77276_a + x, pos.field_77275_b + z));
                        if (multiplier == 0.0) {
                            return 0.0;
                        }
                        result += multiplier;
                    }
                }
                return result / 4.0;
            }
        }
        ,
        EXCLUDE{

            @Override
            double getProbability(Condition c, BlockPos2D pos) {
                if (!c.isStrict()) {
                    return 1.0;
                }
                return c.getProbability(pos);
            }

            @Override
            double getProbability(Condition c, ChunkPos pos) {
                if (!c.isStrict()) {
                    return 1.0;
                }
                return c.getProbability(pos);
            }
        }
        ,
        ONLY{

            @Override
            double getProbability(Condition c, BlockPos2D pos) {
                if (c.isStrict()) {
                    return 1.0;
                }
                return c.getProbability(pos);
            }

            @Override
            double getProbability(Condition c, ChunkPos pos) {
                if (c.isStrict()) {
                    return 1.0;
                }
                return c.getProbability(pos);
            }
        };


        abstract double getProbability(Condition var1, BlockPos2D var2);

        abstract double getProbability(Condition var1, ChunkPos var2);
    }
}

