/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ChunkDataWriter {
    private static final Map<ChunkPos, CompoundNBT> dataLoaded = new HashMap<ChunkPos, CompoundNBT>();
    private static final Map<ChunkPos, List<Consumer<CompoundNBT>>> dataToBeSaved = new HashMap<ChunkPos, List<Consumer<CompoundNBT>>>();

    private ChunkDataWriter() {
    }

    public static CompoundNBT readChunk(ChunkPos chunkPos) {
        if (!dataLoaded.containsKey(chunkPos)) {
            dataLoaded.put(chunkPos, new CompoundNBT());
        }
        CompoundNBT result = dataLoaded.get(chunkPos);
        ChunkDataWriter.modify(chunkPos, result);
        return result;
    }

    public static void write(ChunkPos chunkPos, Consumer<CompoundNBT> func) {
        dataToBeSaved.computeIfAbsent(chunkPos, __ -> new ArrayList()).add(func);
    }

    private static void modify(ChunkPos chunkPos, CompoundNBT nbt) {
        List list = dataToBeSaved.computeIfAbsent(chunkPos, __ -> new ArrayList());
        for (Consumer func : list) {
            func.accept(nbt);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load e) {
        dataLoaded.put(e.getChunk().func_76632_l(), e.getData());
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save e) {
        ChunkDataWriter.modify(e.getChunk().func_76632_l(), e.getData());
        dataToBeSaved.remove(e.getChunk().func_76632_l());
        dataLoaded.remove(e.getChunk().func_76632_l());
    }
}

