/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.util.Lazy;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.SingleDep;
import weightedgpa.infinibiome.api.generators.nonworldgen.SpawnPointBlacklist;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGens;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.minecraftImpl.IBBiomes;

public final class IBBiomeProvider
extends BiomeProvider
implements SingleDep {
    private final PosDataProvider data;
    private final Lazy<StructGens> structGens;
    private final Lazy<List<SpawnPointBlacklist>> spawnPointBlacklists;

    public IBBiomeProvider(DependencyInjector di) {
        super(new HashSet());
        this.data = di.get(PosDataProvider.class);
        this.structGens = Lazy.of(() -> di.get(StructGens.class));
        this.spawnPointBlacklists = Lazy.of(() -> di.getAll(SpawnPointBlacklist.class));
    }

    public List<Biome> func_76932_a() {
        return Collections.emptyList();
    }

    public Biome func_225526_b_(int x, int y, int z) {
        BlockPos2D pos2D = new BlockPos2D(x * 4, z * 4);
        return IBBiomes.getBiome(pos2D, this.data);
    }

    public boolean func_205004_a(Structure<?> structure) {
        return ((StructGens)this.structGens.get()).containsStruct(structure);
    }

    public BlockPos func_225531_a_(int x, int y, int z, int dist, List<Biome> list, Random rand) {
        if (x == 0 && z == 0 && dist == 256) {
            return this.searchSpawn();
        }
        return super.func_225531_a_(x, y, z, dist, list, rand);
    }

    private BlockPos searchSpawn() {
        return new PredicateSearcher<BlockPos2D>(64, p -> {
            if (this.data.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)p).isOcean()) {
                return false;
            }
            for (SpawnPointBlacklist blackList : (List)this.spawnPointBlacklists.get()) {
                if (blackList.canSpawnHere((BlockPos2D)p)) continue;
                return false;
            }
            return true;
        }, BlockPos2D.INFO).getClosestPoint(new BlockPos2D(0, 0)).to3D(0);
    }
}

