/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.ClimateConfig;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class IBBiomes {
    private static final IBBiome[][][][] BIOMES = new IBBiome[20][20][LandType.values().length][AmpType.values().length];
    private static PosDataProvider posData = null;
    private static ClimateConfig climateConfig = null;

    private IBBiomes() {
    }

    public static void refresh(DependencyInjector di) {
        posData = di.get(PosDataProvider.class);
        climateConfig = di.get(ClimateConfig.class);
        DebugCommand.registerDebugFunc("f3_biome", "temperature", p -> Float.valueOf(IBBiomes.getBiome(p, posData).func_185353_n()));
        DebugCommand.registerDebugFunc("f3_biome", "humidity", p -> Float.valueOf(IBBiomes.getBiome(p, posData).func_76727_i()));
        DebugCommand.registerDebugFunc("f3_biome", "dictionary", p -> BiomeDictionary.getTypes((Biome)IBBiomes.getBiome(p, posData)));
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        System.out.println("registering biomes");
        IBBiomes.generateBiomes(event);
    }

    private static void generateBiomes(RegistryEvent.Register<Biome> event) {
        for (TempType temp : TempType.VALUES) {
            for (HumdType humd : HumdType.VALUES) {
                for (LandType landType : LandType.values()) {
                    for (AmpType ampType : AmpType.values()) {
                        IBBiome biome = new IBBiome(temp, humd, landType, ampType);
                        biome.register(event);
                        IBBiomes.BIOMES[temp.ordinal][humd.ordinal][landType.ordinal()][ampType.ordinal()] = biome;
                    }
                }
            }
        }
    }

    public static Biome getBiome(BlockPos2D pos, PosDataProvider data) {
        Optional<Biome> overrideBiome = data.get(PosDataKeys.OVERRIDE_BIOME, pos);
        if (overrideBiome.isPresent()) {
            return overrideBiome.get();
        }
        TempType tempType = TempType.get(pos);
        HumdType humdIndex = HumdType.get(pos);
        LandType landType = LandType.get(pos);
        AmpType ampType = AmpType.getAmp(pos);
        return BIOMES[tempType.ordinal][humdIndex.ordinal][landType.ordinal()][ampType.ordinal()];
    }

    private static enum TreeDensity {
        NONE(new BiomeDictionary.Type[0]),
        SPARSE(BiomeDictionary.Type.SPARSE),
        FOREST(BiomeDictionary.Type.FOREST),
        DENSE(BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);

        final BiomeDictionary.Type[] types;

        private TreeDensity(BiomeDictionary.Type ... types) {
            this.types = types;
        }
    }

    private static enum TreeType {
        NONE(new BiomeDictionary.Type[0]),
        JUNGLE(BiomeDictionary.Type.JUNGLE),
        SPRUCE(BiomeDictionary.Type.COLD),
        DARK(BiomeDictionary.Type.SPOOKY),
        SAVANNAH(BiomeDictionary.Type.SAVANNA);

        final BiomeDictionary.Type[] types;

        private TreeType(BiomeDictionary.Type ... types) {
            this.types = types;
        }
    }

    private static enum AmpType {
        NONE(new BiomeDictionary.Type[0]),
        FLAT(BiomeDictionary.Type.PLAINS),
        HILLS(BiomeDictionary.Type.HILLS),
        MOUNTAIN(BiomeDictionary.Type.MOUNTAIN);

        final BiomeDictionary.Type[] types;

        private AmpType(BiomeDictionary.Type ... types) {
            this.types = types;
        }

        static AmpType getAmp(BlockPos2D pos) {
            double amp = posData.get(PosDataKeys.AMP, pos);
            if (amp < 0.0) {
                return NONE;
            }
            if (amp < 15.0) {
                return FLAT;
            }
            if (amp < 80.0) {
                return HILLS;
            }
            return MOUNTAIN;
        }
    }

    private static enum LandType {
        NONE(new BiomeDictionary.Type[0]),
        BEACH(BiomeDictionary.Type.BEACH),
        OCEAN(BiomeDictionary.Type.OCEAN),
        RIVER(BiomeDictionary.Type.RIVER);

        final BiomeDictionary.Type[] types;

        private LandType(BiomeDictionary.Type ... types) {
            this.types = types;
        }

        static LandType get(BlockPos2D pos) {
            LandmassInfo landmassInfo = posData.get(PosDataKeys.LANDMASS_TYPE, pos);
            if (landmassInfo.isBeach()) {
                return BEACH;
            }
            if (posData.get(PosDataKeys.HEIGHT_MODIFIED_BY_RIVER, pos).booleanValue()) {
                return RIVER;
            }
            if (landmassInfo.isOcean()) {
                return OCEAN;
            }
            return NONE;
        }
    }

    private static class HumdType {
        static final int LENGTH = 20;
        static final List<HumdType> VALUES = IntStream.range(0, 20).mapToObj(HumdType::new).collect(Collectors.toList());
        final int ordinal;

        private HumdType(int ordinal) {
            this.ordinal = ordinal;
        }

        static HumdType get(BlockPos2D pos) {
            double humidity = PosDataHelper.getHumidity(pos, posData);
            return VALUES.get(Interval.PERCENT.mapToIntInterval(humidity, 0, 19));
        }

        double getApproxHumidity() {
            return (double)this.ordinal / 19.0;
        }

        List<BiomeDictionary.Type> getTypes() {
            double temperature = this.getApproxHumidity();
            if (PosDataHelper.DRY_INTERVAL.contains(temperature)) {
                return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY});
            }
            if (PosDataHelper.SEMI_DRY_INTERVAL.contains(temperature)) {
                return Lists.newArrayList();
            }
            if (PosDataHelper.SEMI_WET_INTERVAL.contains(temperature)) {
                return Lists.newArrayList();
            }
            assert (PosDataHelper.WET_INTERVAL.contains(temperature));
            return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WET});
        }
    }

    private static class TempType {
        static final int LENGTH = 20;
        static final List<TempType> VALUES = IntStream.range(0, 20).mapToObj(TempType::new).collect(Collectors.toList());
        final int ordinal;

        private TempType(int ordinal) {
            this.ordinal = ordinal;
        }

        static TempType get(BlockPos2D pos) {
            double temperature = PosDataHelper.getTemperature(pos, posData);
            return VALUES.get(Interval.PERCENT.mapToIntInterval(temperature, 0, 19));
        }

        double getApproxTemperature() {
            return (double)this.ordinal / 19.0;
        }

        List<BiomeDictionary.Type> getTypes() {
            double temperature = this.getApproxTemperature();
            if (PosDataHelper.FREEZE_INTERVAL.contains(temperature)) {
                return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD});
            }
            if (PosDataHelper.COLD_INTERVAL.contains(temperature)) {
                return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD});
            }
            if (PosDataHelper.WARM_INTERVAL.contains(temperature)) {
                return Lists.newArrayList();
            }
            assert (PosDataHelper.HOT_INTERVAL.contains(temperature));
            return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT});
        }
    }

    private static final class IBBiome
    extends Biome {
        final TempType temp;
        final HumdType humd;
        final LandType landType;
        final AmpType ampType;

        IBBiome(TempType temp, HumdType humd, LandType landType, AmpType ampType) {
            super(IBBiome.initBuilder(temp.getApproxTemperature(), humd.getApproxHumidity(), landType));
            this.temp = temp;
            this.humd = humd;
            this.landType = landType;
            this.ampType = ampType;
            this.setRegistryName("infinibiome", this.toString());
        }

        public String toString() {
            return String.format("%s_%s_%s_%s_0_0_0_0", this.temp.ordinal, this.humd.ordinal, this.landType.ordinal(), this.ampType.ordinal());
        }

        public float func_180626_a(BlockPos pos) {
            double temperature = PosDataHelper.getTemperature(pos, posData);
            temperature = PosDataHelper.fuzzTemperature(temperature, MCHelper.to2D(pos), climateConfig);
            return IBBiome.ibTempToMCTemp(temperature);
        }

        public boolean func_201854_a(IWorldReader worldIn, BlockPos pos, boolean mustBeAtEdge) {
            if (IBBiome.isFrozenOcean(pos)) {
                return Biomes.field_76776_l.func_225486_c(pos) < 0.15f;
            }
            if (!IBBiome.isFrozenLand(pos)) {
                return false;
            }
            if (pos.func_177956_o() < 0) {
                return false;
            }
            if (pos.func_177956_o() >= 256) {
                return false;
            }
            if (worldIn.func_226658_a_(LightType.BLOCK, pos) >= 10) {
                return false;
            }
            BlockState blockstate = worldIn.func_180495_p(pos);
            IFluidState ifluidstate = worldIn.func_204610_c(pos);
            if (!ifluidstate.func_206886_c().equals(Fluids.field_204546_a)) {
                return false;
            }
            if (!(blockstate.func_177230_c() instanceof FlowingFluidBlock)) {
                return false;
            }
            if (mustBeAtEdge) {
                return !worldIn.func_201671_F(pos.func_177976_e()) || !worldIn.func_201671_F(pos.func_177974_f()) || !worldIn.func_201671_F(pos.func_177978_c()) || !worldIn.func_201671_F(pos.func_177968_d());
            }
            return true;
        }

        public boolean func_201850_b(IWorldReader worldIn, BlockPos pos) {
            if (!IBBiome.isFrozenLand(pos) && !IBBiome.isFrozenOcean(pos)) {
                return false;
            }
            if (pos.func_177956_o() < 0) {
                return false;
            }
            if (pos.func_177956_o() >= 256) {
                return false;
            }
            if (worldIn.func_226658_a_(LightType.BLOCK, pos) >= 10) {
                return false;
            }
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.isAir((IBlockReader)worldIn, pos) && Blocks.field_150433_aE.func_176223_P().func_196955_c(worldIn, pos);
        }

        static boolean isFrozenOcean(BlockPos pos) {
            BlockPos2D pos2D = MCHelper.to2D(pos);
            if (!posData.get(PosDataKeys.LANDMASS_TYPE, pos2D).isOcean()) {
                return false;
            }
            double temperature = posData.get(PosDataKeys.TEMPERATURE, pos2D).fromHeight(pos.func_177956_o());
            temperature = PosDataHelper.fuzz(temperature, 10.0, new Random(), climateConfig);
            return GenHelper.LOWER_FREEZE_INTERVAL.contains(temperature);
        }

        static boolean isFrozenLand(BlockPos pos) {
            BlockPos2D pos2D = MCHelper.to2D(pos);
            if (posData.get(PosDataKeys.LANDMASS_TYPE, pos2D).isOcean()) {
                return false;
            }
            double temperature = posData.get(PosDataKeys.TEMPERATURE, pos2D).fromHeight(pos.func_177956_o());
            temperature = PosDataHelper.fuzzTemperature(temperature, pos2D, climateConfig);
            return PosDataHelper.FREEZE_INTERVAL.contains(temperature);
        }

        static float ibTempToMCTemp(double ibTemp) {
            if (PosDataHelper.FREEZE_INTERVAL.contains(ibTemp)) {
                return (float)PosDataHelper.FREEZE_INTERVAL.mapInterval(ibTemp, 0.0, 0.14);
            }
            if (PosDataHelper.COLD_INTERVAL.contains(ibTemp)) {
                return (float)PosDataHelper.COLD_INTERVAL.mapInterval(ibTemp, 0.15, 0.81);
            }
            if (PosDataHelper.WARM_INTERVAL.contains(ibTemp)) {
                return (float)PosDataHelper.WARM_INTERVAL.mapInterval(ibTemp, 0.81, 1.0);
            }
            assert (PosDataHelper.HOT_INTERVAL.contains(ibTemp)) : ibTemp;
            return (float)PosDataHelper.WARM_INTERVAL.mapInterval(ibTemp, 1.01, 2.0);
        }

        static float ibHumdToMCHumd(double ibHumd) {
            if (PosDataHelper.DRY_INTERVAL.contains(ibHumd)) {
                return 0.0f;
            }
            if (PosDataHelper.SEMI_DRY_INTERVAL.contains(ibHumd)) {
                return (float)PosDataHelper.SEMI_DRY_INTERVAL.mapInterval(ibHumd, 0.0, 0.4);
            }
            if (PosDataHelper.SEMI_WET_INTERVAL.contains(ibHumd)) {
                return (float)PosDataHelper.SEMI_WET_INTERVAL.mapInterval(ibHumd, 0.4, 0.8);
            }
            assert (PosDataHelper.WET_INTERVAL.contains(ibHumd));
            return (float)PosDataHelper.WET_INTERVAL.mapInterval(ibHumd, 0.8, 1.0);
        }

        void register(RegistryEvent.Register<Biome> event) {
            event.getRegistry().register((IForgeRegistryEntry)this);
            ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
            types.add(BiomeDictionary.Type.OVERWORLD);
            types.addAll(this.temp.getTypes());
            types.addAll(this.humd.getTypes());
            types.addAll(Arrays.asList(this.landType.types));
            types.addAll(Arrays.asList(this.ampType.types));
            BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])types.toArray(new BiomeDictionary.Type[0]));
        }

        static Biome.Builder initBuilder(double temperature, double humidity, LandType landType) {
            Biome.Builder builder = new Biome.Builder();
            IBBiome.setCategory(builder, temperature, humidity, landType);
            IBBiome.setPrecipitationType(builder, temperature, humidity);
            IBBiome.setDownFall(builder, humidity);
            IBBiome.setTemp(builder, temperature);
            IBBiome.setDummyDatas(builder);
            return builder;
        }

        static void setCategory(Biome.Builder builder, double temperature, double humidity, LandType landType) {
            if (landType == LandType.RIVER) {
                builder.func_205419_a(Biome.Category.RIVER);
                return;
            }
            if (landType == LandType.BEACH) {
                builder.func_205419_a(Biome.Category.BEACH);
                return;
            }
            if (landType == LandType.OCEAN) {
                builder.func_205419_a(Biome.Category.OCEAN);
                return;
            }
            if (PosDataHelper.HOT_INTERVAL.contains(temperature) && PosDataHelper.SEMI_DRY_INTERVAL.contains(humidity)) {
                builder.func_205419_a(Biome.Category.SAVANNA);
                return;
            }
            if (PosDataHelper.HOT_INTERVAL.contains(temperature) && PosDataHelper.WET_INTERVAL.contains(humidity)) {
                builder.func_205419_a(Biome.Category.JUNGLE);
                return;
            }
            if (PosDataHelper.DRY_INTERVAL.contains(humidity)) {
                builder.func_205419_a(Biome.Category.DESERT);
                return;
            }
            if (PosDataHelper.FREEZE_INTERVAL.contains(temperature)) {
                builder.func_205419_a(Biome.Category.ICY);
                return;
            }
            if (PosDataHelper.COLD_INTERVAL.contains(temperature)) {
                builder.func_205419_a(Biome.Category.TAIGA);
                return;
            }
            builder.func_205419_a(Biome.Category.FOREST);
        }

        static void setPrecipitationType(Biome.Builder builder, double temperature, double humidity) {
            if (PosDataHelper.DRY_INTERVAL.contains(humidity)) {
                builder.func_205415_a(Biome.RainType.NONE);
                return;
            }
            if (PosDataHelper.FREEZE_INTERVAL.contains(temperature)) {
                builder.func_205415_a(Biome.RainType.SNOW);
                return;
            }
            builder.func_205415_a(Biome.RainType.RAIN);
        }

        static void setDownFall(Biome.Builder builder, double humidity) {
            builder.func_205417_d(IBBiome.ibHumdToMCHumd(humidity));
        }

        static void setTemp(Biome.Builder builder, double temperature) {
            builder.func_205414_c(IBBiome.ibTempToMCTemp(temperature));
        }

        static void setDummyDatas(Biome.Builder builder) {
            builder.func_205412_a(4159204).func_205413_b(329011).func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v).func_205421_a(1.0f).func_205420_b(1.0f).func_205418_a(null);
        }
    }
}

