/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;
import org.apache_.commons.lang3.mutable.MutableObject;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.StructGen;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.generators.chunks.ChunkGens;
import weightedgpa.infinibiome.internal.generators.interchunks.InterChunkGens;
import weightedgpa.infinibiome.internal.generators.interchunks.struct.StructGens;
import weightedgpa.infinibiome.internal.generators.nonworldgen.spawnList.MobSpawnListModifiers;
import weightedgpa.infinibiome.internal.generators.nonworldgen.spawners.MobSpawners;
import weightedgpa.infinibiome.internal.minecraftImpl.IBBiomes;
import weightedgpa.infinibiome.internal.minecraftImpl.PosEmbeddedBiomes;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class IBChunkGenerator
extends ChunkGenerator<GenerationSettings> {
    private final PosDataProvider posData;
    private final Lazy<ChunkGens> chunkGens;
    private final Lazy<InterChunkGens> interChunkGens;
    private final Lazy<MobSpawners> tickers;
    private final Lazy<MobSpawnListModifiers> mobSpawnListModifiers;
    private final Lazy<StructGens> structs;

    public IBChunkGenerator(DependencyInjector di) {
        super((IWorld)di.get(ServerWorld.class), di.get(BiomeProvider.class), new GenerationSettings());
        this.posData = di.get(PosDataProvider.class);
        this.chunkGens = Lazy.of(() -> di.get(ChunkGens.class));
        this.interChunkGens = Lazy.of(() -> di.get(InterChunkGens.class));
        this.structs = Lazy.of(() -> di.get(StructGens.class));
        this.tickers = Lazy.of(() -> di.get(MobSpawners.class));
        this.mobSpawnListModifiers = Lazy.of(() -> di.get(MobSpawnListModifiers.class));
    }

    public void func_222539_a(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        ((ChunkPrimer)chunkIn).func_225548_a_(new BiomeContainer(chunkpos, this.field_222542_c));
    }

    public Biome func_225552_a_(BiomeManager biomeManagerIn, BlockPos posIn) {
        return super.func_225552_a_(biomeManagerIn, posIn);
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        ((ChunkGens)this.chunkGens.get()).buildChunk(chunkIn.func_76632_l(), chunkIn);
    }

    public void func_202092_b(WorldGenRegion region) {
        InterChunkPos interChunkPos = new InterChunkPos(new ChunkPos(region.func_201679_a(), region.func_201680_b()));
        ((InterChunkGens)this.interChunkGens.get()).generateAll(interChunkPos, (IWorld)region);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        if (creatureType == EntityClassification.CREATURE) {
            return Collections.emptyList();
        }
        List result = IBBiomes.getBiome(MCHelper.to2D(pos), this.posData).func_76747_a(creatureType);
        ((MobSpawnListModifiers)this.mobSpawnListModifiers.get()).modifyList(pos, creatureType, result, this.field_222540_a);
        return result;
    }

    public int func_205470_d() {
        return 63;
    }

    public int func_222530_f() {
        return 63;
    }

    public int func_222529_a(int x, int z, Heightmap.Type type) {
        int level = (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, new BlockPos2D(x, z)) + 1;
        if (type == Heightmap.Type.OCEAN_FLOOR || type == Heightmap.Type.OCEAN_FLOOR_WG) {
            return level;
        }
        return Math.max(this.func_222530_f(), level);
    }

    public boolean func_202094_a(Biome biomeIn, Structure<? extends IFeatureConfig> structureIn) {
        return this.func_202087_b(biomeIn, structureIn) != null;
    }

    @Nullable
    public <C extends IFeatureConfig> C func_202087_b(Biome biomeIn, Structure<C> structureIn) {
        if (!(biomeIn instanceof PosEmbeddedBiomes.Biome)) {
            return null;
        }
        return ((StructGens)this.structs.get()).getConfig(structureIn, ((PosEmbeddedBiomes.Biome)biomeIn).getPos());
    }

    public void func_227058_a_(BiomeManager __, IChunk chunk, ChunkGenerator<?> ___, TemplateManager templateManager) {
        BlockPos pos = new BlockPos(chunk.func_76632_l().func_180334_c() + 9, 0, chunk.func_76632_l().func_180333_d() + 9);
        Biome biome = PosEmbeddedBiomes.MANAGER.func_226836_a_(pos);
        ((StructGens)this.structs.get()).forEachStructs(structGen -> {
            Structure structure = structGen.getStruct();
            int refCount = this.getRefCount(structure, (IStructureReader)chunk);
            StructureStart structurestart = null;
            if (this.canSpawn((StructGen<?>)structGen, chunk)) {
                structurestart = structure.func_214557_a().create(structure, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, MutableBoundingBox.func_78887_a(), refCount, this.func_202089_c());
                structurestart.func_214625_a((ChunkGenerator)this, templateManager, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, biome);
            }
            if (structurestart == null || !structurestart.func_75069_d()) {
                structurestart = StructureStart.field_214630_a;
            }
            chunk.func_201584_a(structure.func_143025_a(), structurestart);
        });
    }

    private int getRefCount(Structure<?> structure, IStructureReader chunk) {
        StructureStart structurestart = chunk.func_201585_a(structure.func_143025_a());
        if (structurestart != null) {
            return structurestart.func_227457_j_();
        }
        return 0;
    }

    private boolean canSpawn(StructGen<?> structGen, IChunk chunk) {
        return structGen.getConfigAt(chunk.func_76632_l()) != null;
    }

    @Nullable
    public BlockPos func_211403_a(World worldIn, String name, BlockPos pos, int radius, boolean p_211403_5_) {
        MutableObject<Object> result = new MutableObject<Object>(null);
        ((StructGens)this.structs.get()).forEachStructs(structGen -> {
            if (result.getValue() != null) {
                return;
            }
            if (!structGen.getStruct().func_143025_a().equals(name)) {
                return;
            }
            result.setValue(structGen.getClosestInstance(MCHelper.to2D(pos)));
        });
        if (result.getValue() == null) {
            return null;
        }
        return ((BlockPos2D)result.getValue()).to3D(0);
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        ((MobSpawners)this.tickers.get()).run(worldIn);
    }

    public void func_202093_c(WorldGenRegion worldGenRegion) {
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk iChunk) {
    }

    public void func_225550_a_(BiomeManager p_225550_1_, IChunk p_225550_2_, GenerationStage.Carving p_225550_3_) {
    }
}

