/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.misc.MathHelper;

final class CommandHelper {
    private static final Pattern SPECIAL_CHAR = Pattern.compile("[{}=,]");
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern COLON = Pattern.compile(":");
    private static final Pattern AT = Pattern.compile("@");
    private static final Pattern GEN = Pattern.compile("Gen$");

    private CommandHelper() {
    }

    static String fix(String name) {
        name = CommandHelper.replaceSpecialCharacters(name);
        name = CommandHelper.removeImport(name);
        name = CommandHelper.removeColon(name);
        name = CommandHelper.removeHex(name);
        name = CommandHelper.removeGen(name);
        return name;
    }

    private static String replaceSpecialCharacters(String str) {
        return SPECIAL_CHAR.matcher(str).replaceAll("_");
    }

    private static String removeImport(String str) {
        String[] split = DOT.split(str, 0);
        return split[split.length - 1];
    }

    private static String removeColon(String str) {
        String[] split = COLON.split(str, 0);
        return split[split.length - 1];
    }

    private static String removeHex(String str) {
        String[] split = AT.split(str, 0);
        return split[0];
    }

    private static String removeGen(String str) {
        return GEN.matcher(str).replaceAll("");
    }

    static void printPos(@Nullable BlockPos2D result, String name, CommandSource source) {
        if (result == null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.locate.failed", new Object[0]), true);
            return;
        }
        BlockPos2D playerPos = new BlockPos2D((int)source.func_197036_d().field_72450_a, (int)source.func_197036_d().field_72449_c);
        int dist = (int)MathHelper.getDistance(BlockPos2D.INFO, result, playerPos);
        ITextComponent itextcomponent = TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{result.getBlockX(), "~", result.getBlockZ()})).func_211710_a(p_211746_1_ -> p_211746_1_.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + result.getBlockX() + " ~ " + result.getBlockZ())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.locate.success", new Object[]{name, itextcomponent, dist}), true);
    }

    static <T> Command<T> wrap(Consumer<CommandContext<T>> command) {
        return csc -> {
            try {
                command.accept(csc);
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        };
    }
}

