/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeGens;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.CommandHelper;
import weightedgpa.infinibiome.internal.misc.Helper;

public final class LocateClimateCommand {
    private static PosDataProvider data = null;
    private static TreeGens treeGens = null;

    private LocateClimateCommand() {
    }

    public static void refresh(DependencyInjector di) {
        data = di.get(PosDataProvider.class);
        treeGens = di.get(TreeGens.class);
    }

    static LiteralArgumentBuilder<CommandSource> init() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"locateClimate").then(Commands.func_197056_a((String)"temperature", (ArgumentType)new FloatOrAnyArguments(Interval.PERCENT)).then(Commands.func_197056_a((String)"humidity", (ArgumentType)new FloatOrAnyArguments(Interval.PERCENT)).then(Commands.func_197056_a((String)"amplitude", (ArgumentType)new FloatOrAnyArguments(new Interval(0.0, 200.0))).then(Commands.func_197056_a((String)"treeDensity", (ArgumentType)new FloatOrAnyArguments(Interval.PERCENT)).executes(CommandHelper.wrap(LocateClimateCommand::runCommand))))));
    }

    private static void runCommand(CommandContext<CommandSource> csc) {
        new Thread(() -> {
            BlockPos2D result = Helper.timed(30, () -> LocateClimateCommand.locateClimate(new BlockPos2D((int)((CommandSource)csc.getSource()).func_197036_d().field_72450_a, (int)((CommandSource)csc.getSource()).func_197036_d().field_72449_c), (Interval)csc.getArgument("temperature", Interval.class), (Interval)csc.getArgument("humidity", Interval.class), (Interval)csc.getArgument("amplitude", Interval.class), (Interval)csc.getArgument("treeDensity", Interval.class)));
            CommandHelper.printPos(result, "climate", (CommandSource)csc.getSource());
        }).start();
    }

    private static BlockPos2D locateClimate(BlockPos2D centerPos, Interval temperature, Interval humidity, Interval amplitude, Interval treeDensity) {
        return new PredicateSearcher<BlockPos2D>(32, pos -> {
            if (!data.get(PosDataKeys.LANDMASS_TYPE, (BlockPos2D)pos).isLand()) {
                return false;
            }
            if (data.get(PosDataKeys.IS_MUSHROOM_ISLAND, (BlockPos2D)pos).booleanValue()) {
                return false;
            }
            if (!LocateClimateCommand.isCloseEnough(temperature, () -> PosDataHelper.getTemperature(pos, data))) {
                return false;
            }
            if (!LocateClimateCommand.isCloseEnough(humidity, () -> PosDataHelper.getHumidity(pos, data))) {
                return false;
            }
            if (!LocateClimateCommand.isCloseEnough(amplitude, () -> data.get(PosDataKeys.AMP, (BlockPos2D)pos))) {
                return false;
            }
            return LocateClimateCommand.isCloseEnough(treeDensity, () -> LocateClimateCommand.getTreeDensity(pos));
        }, BlockPos2D.INFO).getClosestPoint(centerPos);
    }

    private static double getTreeDensity(BlockPos2D pos) {
        double humidity = PosDataHelper.getHumidity(pos, data);
        if (PosDataHelper.DRY_INTERVAL.contains(humidity)) {
            return 0.0;
        }
        return treeGens.getApproxDensity(new InterChunkPos(pos));
    }

    private static boolean isCloseEnough(Interval wanted, Supplier<Double> actualFunc) {
        if (wanted.equals(Interval.ALL_VALUES)) {
            return true;
        }
        return wanted.contains(actualFunc.get());
    }

    private static final class FloatOrAnyArguments
    implements ArgumentType<Interval> {
        private final Interval acceptable;

        FloatOrAnyArguments(Interval acceptable) {
            this.acceptable = acceptable;
        }

        public Interval parse(StringReader reader) throws CommandSyntaxException {
            String str = reader.readUnquotedString();
            if (!str.contains("_")) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidFloat().createWithContext((ImmutableStringReader)reader, (Object)str);
            }
            String[] args = str.split("_", -1);
            return new Interval(this.parse(args[0], Double.NEGATIVE_INFINITY, (ImmutableStringReader)reader), this.parse(args[1], Double.POSITIVE_INFINITY, (ImmutableStringReader)reader));
        }

        private double parse(String str, double defaultValue, ImmutableStringReader reader) throws CommandSyntaxException {
            if (str.isEmpty()) {
                return defaultValue;
            }
            return this.parse(str, reader);
        }

        private double parse(String str, ImmutableStringReader reader) throws CommandSyntaxException {
            double result;
            try {
                result = Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidFloat().createWithContext(reader, (Object)str);
            }
            if (result < this.acceptable.getMin()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.floatTooLow().createWithContext(reader, (Object)result, (Object)this.acceptable.getMin());
            }
            if (result > this.acceptable.getMax()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.floatTooHigh().createWithContext(reader, (Object)result, (Object)this.acceptable.getMax());
            }
            return result;
        }
    }
}

