/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.math.Vec3d;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.CommandHelper;
import weightedgpa.infinibiome.internal.misc.Helper;

public final class LocateObjectCommand {
    private static final Map<String, Locatable> locatables = new HashMap<String, Locatable>();

    private LocateObjectCommand() {
    }

    public static void refresh(DependencyInjector di) {
        locatables.clear();
        for (Locatable l : di.getAll(Locatable.class)) {
            locatables.put(CommandHelper.fix(l.toString()), l);
        }
    }

    static LiteralCommandNode<CommandSource> init() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").then(Commands.func_197056_a((String)"name", (ArgumentType)new LocatableArguments()).executes(CommandHelper.wrap(LocateObjectCommand::runCommand)))).build();
    }

    private static void runCommand(CommandContext<CommandSource> csc) {
        new Thread(() -> {
            Vec3d pos = ((CommandSource)csc.getSource()).func_197036_d();
            Locatable locatable = (Locatable)csc.getArgument("name", Locatable.class);
            BlockPos2D result = Helper.timed(60, () -> locatable.getClosestInstance(new BlockPos2D((int)pos.field_72450_a, (int)pos.field_72449_c)));
            CommandHelper.printPos(result, CommandHelper.fix(locatable.toString()), (CommandSource)csc.getSource());
        }).start();
    }

    private static class LocatableArguments
    implements ArgumentType<Locatable> {
        private LocatableArguments() {
        }

        public Locatable parse(StringReader reader) throws CommandSyntaxException {
            return (Locatable)locatables.get(reader.readUnquotedString());
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            try {
                return ISuggestionProvider.func_197005_b(locatables.keySet(), (SuggestionsBuilder)builder);
            }
            catch (ConcurrentModificationException e) {
                return new CompletableFuture<Suggestions>();
            }
        }
    }
}

