/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.minecraftImpl.world;

import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.StructGen;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.generators.chunks.ChunkGens;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;

public final class SimulatedWorld {
    private final ChunkGens chunkGens;
    private final List<InterChunkGen> interChunks;
    private final ChunkGenerator chunkGenerator;
    private final ServerWorld world;

    public SimulatedWorld(DependencyInjector di) {
        this.chunkGens = di.get(ChunkGens.class);
        this.interChunks = di.getAll(InterChunkGen.class);
        this.chunkGenerator = di.get(ChunkGenerator.class);
        this.world = di.get(ServerWorld.class);
        this.interChunks.removeIf(g -> g instanceof StructGen || g instanceof MobGenBase);
    }

    public IWorld simulateInterchunks(InterChunkPos interChunkPos) {
        InterChunks interChunkWorld = new InterChunks(interChunkPos);
        this.interChunks.forEach(g -> g.generate(interChunkPos, interChunkWorld));
        return interChunkWorld;
    }

    private class InterChunks
    implements IWorld {
        private final BlockState[][][] blocks = new BlockState[32][256][32];
        private final InterChunkPos interChunkPos;

        InterChunks(InterChunkPos interChunkPos) {
            this.interChunkPos = interChunkPos;
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    ChunkPos chunkPos = new ChunkPos(interChunkPos.getLowestChunkPos().field_77276_a + x, interChunkPos.getLowestChunkPos().field_77275_b + z);
                    ChunkWrapper chunk = new ChunkWrapper(chunkPos);
                    SimulatedWorld.this.chunkGens.buildChunk(chunkPos, chunk);
                }
            }
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public BlockState func_180495_p(BlockPos pos) {
            BlockState block;
            int x = pos.func_177958_n() - this.interChunkPos.getLowestChunkPos().func_180334_c();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p() - this.interChunkPos.getLowestChunkPos().func_180333_d();
            if (y < 0) {
                y = 0;
            }
            if (y > 255) {
                y = 255;
            }
            if ((block = this.blocks[x][y][z]) == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return block;
        }

        public IFluidState func_204610_c(BlockPos pos) {
            return this.func_180495_p(pos).func_204520_s();
        }

        public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
            int x = pos.func_177958_n() - this.interChunkPos.getLowestChunkPos().func_180334_c();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p() - this.interChunkPos.getLowestChunkPos().func_180333_d();
            if (y < 0) {
                y = 0;
            }
            if (y > 255) {
                y = 255;
            }
            this.blocks[x][y][z] = newState;
            return true;
        }

        public boolean func_217377_a(BlockPos pos, boolean isMoving) {
            return this.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 20);
        }

        public boolean func_175655_b(BlockPos p_175655_1_, boolean p_175655_2_) {
            return this.func_217377_a(p_175655_1_, p_175655_2_);
        }

        public boolean func_225521_a_(BlockPos blockPos, boolean b, @Nullable Entity entity) {
            return this.func_217377_a(blockPos, b);
        }

        public boolean func_217375_a(BlockPos pos, Predicate<BlockState> predicate) {
            return predicate.test(this.func_180495_p(pos));
        }

        public long func_72905_C() {
            return SimulatedWorld.this.chunkGenerator.func_202089_c();
        }

        public ITickList<Block> func_205220_G_() {
            return EmptyTickList.func_205388_a();
        }

        public ITickList<Fluid> func_205219_F_() {
            return EmptyTickList.func_205388_a();
        }

        public int func_181545_F() {
            return 63;
        }

        public int getMaxHeight() {
            return 256;
        }

        public Random func_201674_k() {
            return new Random();
        }

        public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
            BlockPos.Mutable mutPos = new BlockPos.Mutable(x, 0, z);
            for (int y = 255; y > 1; --y) {
                mutPos.func_185336_p(y);
                if (!heightmapType.func_222684_d().test(this.func_180495_p((BlockPos)mutPos))) continue;
                return y + 1;
            }
            return 0;
        }

        @Nullable
        public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
            return new ChunkWrapper(new ChunkPos(x, z));
        }

        public boolean func_201670_d() {
            return false;
        }

        public WorldBorder func_175723_af() {
            return SimulatedWorld.this.world.func_175723_af();
        }

        public WorldInfo func_72912_H() {
            return SimulatedWorld.this.world.func_72912_H();
        }

        public int func_175657_ab() {
            return SimulatedWorld.this.world.func_175657_ab();
        }

        public Dimension func_201675_m() {
            return SimulatedWorld.this.world.func_201675_m();
        }

        public WorldLightManager func_225524_e_() {
            return SimulatedWorld.this.world.func_225524_e_();
        }

        public BiomeManager func_225523_d_() {
            return SimulatedWorld.this.world.func_225523_d_();
        }

        public DifficultyInstance func_175649_E(BlockPos pos) {
            return SimulatedWorld.this.world.func_175649_E(pos);
        }

        public BlockPos func_175694_M() {
            return SimulatedWorld.this.world.func_175694_M();
        }

        public void func_195592_c(BlockPos pos, Block blockIn) {
        }

        public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        }

        public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        }

        public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        }

        public World func_201672_e() {
            throw new UnsupportedOperationException();
        }

        public AbstractChunkProvider func_72863_F() {
            throw new UnsupportedOperationException();
        }

        public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
            throw new UnsupportedOperationException();
        }

        public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
            throw new UnsupportedOperationException();
        }

        public List<? extends PlayerEntity> func_217369_A() {
            throw new UnsupportedOperationException();
        }

        public Biome func_225604_a_(int x, int y, int z) {
            throw new UnsupportedOperationException();
        }

        private class ChunkWrapper
        implements IChunk {
            private final ChunkPos chunkPos;

            ChunkWrapper(ChunkPos chunkPos) {
                this.chunkPos = chunkPos;
            }

            public ChunkPos func_76632_l() {
                return this.chunkPos;
            }

            public BlockState func_180495_p(BlockPos pos) {
                return InterChunks.this.func_180495_p(pos);
            }

            public IFluidState func_204610_c(BlockPos pos) {
                return InterChunks.this.func_204610_c(pos);
            }

            @Nullable
            public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
                InterChunks.this.func_180501_a(pos, state, 20);
                return state;
            }

            public BitSet func_205749_a(GenerationStage.Carving type) {
                return new BitSet(65536);
            }

            public int func_201576_a(Heightmap.Type heightmapType, int x, int z) {
                return InterChunks.this.func_201676_a(heightmapType, x, z) - 1;
            }

            public ITickList<Block> func_205218_i_() {
                return new EmptyTickList();
            }

            public ITickList<Fluid> func_212247_j() {
                return new EmptyTickList();
            }

            @Nullable
            public TileEntity func_175625_s(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            public void func_177426_a(BlockPos pos, TileEntity tileEntityIn) {
                throw new UnsupportedOperationException();
            }

            public void func_76612_a(Entity entityIn) {
                throw new UnsupportedOperationException();
            }

            public Set<BlockPos> func_203066_o() {
                throw new UnsupportedOperationException();
            }

            public ChunkSection[] func_76587_i() {
                throw new UnsupportedOperationException();
            }

            public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f() {
                throw new UnsupportedOperationException();
            }

            public void func_201607_a(Heightmap.Type type, long[] data) {
                throw new UnsupportedOperationException();
            }

            public Heightmap func_217303_b(Heightmap.Type typeIn) {
                throw new UnsupportedOperationException();
            }

            public void func_177432_b(long saveTime) {
                throw new UnsupportedOperationException();
            }

            public Map<String, StructureStart> func_201609_c() {
                throw new UnsupportedOperationException();
            }

            public void func_201612_a(Map<String, StructureStart> structureStartsIn) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public BiomeContainer func_225549_i_() {
                throw new UnsupportedOperationException();
            }

            public void func_177427_f(boolean modified) {
                throw new UnsupportedOperationException();
            }

            public boolean func_201593_f() {
                throw new UnsupportedOperationException();
            }

            public ChunkStatus func_201589_g() {
                throw new UnsupportedOperationException();
            }

            public void func_177425_e(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            public ShortList[] func_201614_D() {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public CompoundNBT func_201579_g(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public CompoundNBT func_223134_j(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            public Stream<BlockPos> func_217304_m() {
                throw new UnsupportedOperationException();
            }

            public UpgradeData func_196966_y() {
                throw new UnsupportedOperationException();
            }

            public void func_177415_c(long newInhabitedTime) {
                throw new UnsupportedOperationException();
            }

            public long func_177416_w() {
                throw new UnsupportedOperationException();
            }

            public boolean func_217310_r() {
                throw new UnsupportedOperationException();
            }

            public void func_217305_b(boolean lightCorrectIn) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public StructureStart func_201585_a(String stucture) {
                throw new UnsupportedOperationException();
            }

            public void func_201584_a(String structureIn, StructureStart structureStartIn) {
                throw new UnsupportedOperationException();
            }

            public LongSet func_201578_b(String structureIn) {
                throw new UnsupportedOperationException();
            }

            public void func_201583_a(String strucutre, long reference) {
                throw new UnsupportedOperationException();
            }

            public Map<String, LongSet> func_201604_d() {
                throw new UnsupportedOperationException();
            }

            public void func_201606_b(Map<String, LongSet> p_201606_1_) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

