/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class EntityHelper {
    private static final Field GOALS_FIELD = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");

    private EntityHelper() {
    }

    public static void removeGoals(GoalSelector goalSelector, Predicate<Goal> goalRemoval) {
        EntityHelper.getGoalSet(goalSelector).removeIf(g -> goalRemoval.test(g.func_220772_j()));
    }

    static void removeGoals(GoalSelector goalSelector, int priority) {
        EntityHelper.getGoalSet(goalSelector).removeIf(g -> g.func_220770_h() == priority);
    }

    static void shiftGoalsDown(int priority, GoalSelector goalSelector) {
        Set<PrioritizedGoal> goals = EntityHelper.getGoalSet(goalSelector);
        for (PrioritizedGoal goal : new ArrayList<PrioritizedGoal>(goals)) {
            if (goal.func_220770_h() < priority) continue;
            goals.remove(goal);
            goals.add(new PrioritizedGoal(goal.func_220770_h() + 1, goal.func_220772_j()));
        }
    }

    private static Set<PrioritizedGoal> getGoalSet(GoalSelector goal) {
        try {
            return (Set)GOALS_FIELD.get(goal);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean inVillage(BlockPos pos, IWorld world) {
        return !world.func_217348_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, ChunkStatus.field_222607_c).func_201578_b(Feature.field_214550_p.func_143025_a()).isEmpty();
    }

    static void applyModifier(LivingEntity entity, IAttribute attribute, AttributeModifier modifier) {
        if (entity.func_110148_a(attribute).func_180374_a(modifier)) {
            return;
        }
        entity.func_110148_a(attribute).func_111121_a(modifier);
    }

    static void removeModifier(LivingEntity entity, IAttribute attribute, AttributeModifier modifier) {
        if (!entity.func_110148_a(attribute).func_180374_a(modifier)) {
            return;
        }
        entity.func_110148_a(attribute).func_111124_b(modifier);
    }
}

