/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import org.apache_.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.PerlinNoise;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class Helper {
    public static final double COMMON_SCALE = 2048.0;
    private static final double COS_ONE_FORTH_PI = StrictMath.cos(0.7853981633974483);

    private Helper() {
    }

    public static FloatFunc<BlockPos2D> initUniformNoise(Seed seed, double scale) {
        return new PerlinNoise<BlockPos2D>(seed, scale, BlockPos2D.INFO).toUniform(PerlinNoise.PERCENTILE_TABLE);
    }

    public static <I> boolean passesSurroundingTest(I center, int radius, Predicate<I> condition, IntPosInfo<I> posInfo) {
        assert (radius >= 0) : radius;
        if (radius == 0) {
            return condition.test(center);
        }
        for (I placeToCheck : Helper.getSearchPos(center, radius, posInfo)) {
            if (condition.test(placeToCheck)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <I> I findSuitableSpot(I center, int radius, Predicate<I> condition, IntPosInfo<I> posInfo) {
        assert (radius > 0) : radius;
        for (I placeToCheck : Helper.getSearchPos(center, radius, posInfo)) {
            if (!condition.test(placeToCheck)) continue;
            return placeToCheck;
        }
        return null;
    }

    private static <I> List<I> getSearchPos(I center, int radius, IntPosInfo<I> posInfo) {
        assert (radius >= 0);
        int diagonal = (int)Math.round((double)radius * COS_ONE_FORTH_PI);
        return Lists.newArrayList((Object[])new Object[]{center, posInfo.offset(center, radius, 0), posInfo.offset(center, -radius, 0), posInfo.offset(center, 0, radius), posInfo.offset(center, 0, -radius), posInfo.offset(center, diagonal, diagonal), posInfo.offset(center, diagonal, -diagonal), posInfo.offset(center, -diagonal, diagonal), posInfo.offset(center, -diagonal, -diagonal)});
    }

    @Nullable
    public static <T> T timed(int seconds, Supplier<? extends T> supplier) {
        assert (seconds > 0);
        ExecutorService thread = Executors.newSingleThreadExecutor();
        Future<Object> result = thread.submit(supplier::get);
        try {
            return (T)result.get(seconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static DataInput getResource(String resourceName) {
        return new DataInputStream(Helper.class.getResourceAsStream(resourceName));
    }

    public static <T> boolean intersects(Collection<T> list1, Collection<T> list2) {
        for (T a : list1) {
            for (T b : list2) {
                if (!a.equals(b)) continue;
                return true;
            }
        }
        return false;
    }

    public static long packXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static int getIntX(long mergedXZ) {
        return (int)(mergedXZ >> 32);
    }

    public static int getIntZ(long mergedXZ) {
        return (int)mergedXZ;
    }

    public static void iterXZParallel(int width, int height, BiConsumer<Integer, Integer> consumer) {
        assert (width > 0);
        assert (height > 0);
        long total = (long)width * (long)height;
        LongStream.range(0L, total).parallel().forEach(i -> consumer.accept((int)(i / (long)height), (int)(i % (long)height)));
    }

    public static <T> void strictSort(List<T> list, Comparator<T> comparator) {
        list.sort(comparator);
        for (int i = 0; i < list.size() - 1; ++i) {
            T next;
            T current = list.get(i);
            if (comparator.compare(current, next = list.get(i + 1)) != 0) continue;
            throw new IllegalStateException("objects are not allowed to have equal precedent");
        }
    }

    public static <T> List<T> shuffle(List<T> list, Random random) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.shuffle(result, random);
        return result;
    }

    public static void placeClusterWithUnknownHeight(BlockPos centerPos, FloatFunc<BlockPos2D> radiusNoise, IWorldReader world, Consumer<BlockPos> placeAt) {
        int centerHeight = centerPos.func_177956_o();
        BlockPos2D centerPos2D = MCHelper.to2D(centerPos);
        int radiusMax = MathHelper.ceil(radiusNoise.getOutputInterval().getMax());
        for (int x = -radiusMax; x <= radiusMax; ++x) {
            for (int z = -radiusMax; z <= radiusMax; ++z) {
                BlockPos2D currentPos2D = centerPos2D.offset(x, z);
                MutableInt currentHeight = new MutableInt(centerHeight);
                Helper.forEachPathBetween(centerPos2D, currentPos2D, p -> {
                    Integer newHeight = Helper.adjustHeight(p, currentHeight.getValue(), world);
                    if (newHeight == null) {
                        return false;
                    }
                    currentHeight.setValue(newHeight);
                    return true;
                });
                BlockPos currentPos = currentPos2D.to3D(currentHeight.getValue());
                placeAt.accept(currentPos);
            }
        }
    }

    private static void forEachPathBetween(BlockPos2D from, BlockPos2D to, Predicate<BlockPos2D> consumer) {
        BlockPos2D currPos = from;
        while (!currPos.equals(to)) {
            boolean continueFlag = consumer.test(currPos);
            if (!continueFlag) {
                return;
            }
            int xDirection = Integer.signum(to.getBlockX() - from.getBlockX());
            int zDirection = Integer.signum(to.getBlockZ() - from.getBlockZ());
            currPos = currPos.offset(xDirection, zDirection);
        }
    }

    @Nullable
    private static Integer adjustHeight(BlockPos2D currentPos, int centerHeight, IWorldReader world) {
        BlockState initialBlock = world.func_180495_p(currentPos.to3D(centerHeight));
        int scanDirection = MCHelper.isSolid(initialBlock) ? 1 : -1;
        for (int scannedHeight = centerHeight; scannedHeight >= 0 && scannedHeight <= 255; scannedHeight += scanDirection) {
            BlockPos currPos = currentPos.to3D(scannedHeight);
            if (!MCHelper.isMostlyAir(world.func_180495_p(currPos)) || !MCHelper.isSolid(world.func_180495_p(currPos.func_177977_b()))) continue;
            return scannedHeight;
        }
        return null;
    }

    public static <T> void set(Object o, Field field, T newValue) {
        field.setAccessible(true);
        try {
            field.set(o, newValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T pickWeighted(Function<T, Double> toWeight, Random random, List<T> list) {
        assert (!list.isEmpty());
        ArrayList<T> possible = new ArrayList<T>();
        double total = 0.0;
        for (T t : list) {
            total += toWeight.apply(t).doubleValue();
            possible.add(t);
        }
        if (total == 0.0) {
            int randomIndex = random.nextInt(possible.size());
            return (T)possible.get(randomIndex);
        }
        double randomValue = MathHelper.lerp(random.nextDouble(), 0.0, total);
        double cummulative = 0.0;
        for (Object t : possible) {
            if (!((cummulative += toWeight.apply(t).doubleValue()) >= randomValue)) continue;
            return (T)t;
        }
        throw new RuntimeException("should never happen");
    }
}

